/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProject;
import com.yifu.cloud.plus.v1.yifu.archives.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 项目档案表
 *
 * @author huyc
 * @date 2022-06-20 09:19:40
 */
@Mapper
public interface TEmployeeProjectMapper extends BaseMapper<TEmployeeProject> {

	void updateExcelEmpProject(@Param("list") List<TEmployeeProject> list);

	void updateReduceEmpProject(@Param("list") List<TEmployeeProject> list);

	int insertExcelEmpProject(@Param("list") List<TEmployeeProject> list);

	void updateEmpIdById(@Param("list") List<TEmployeeInfo> list);

	/**
	 * 通过部门编码获取最大员工编码
	 * @param deptNo
	 * @return
	 */
	String findEmployeeMaxOnlyNoByDepId(@Param("deptNo") String deptNo);

	IPage<TEmployeeProject> getTEmployeeProjectInfoPage(Page page, @Param("tEmployeeProject") TEmployeeProject tEmployeeProject);

	// getTEmployeeProjectExportPage  改造
    List<EmployeeProjectExportVO> noPageDiy(@Param("tEmployeeProject")EmployeeProjectExportParamVO searchVo);

	int noPageCountDiy(@Param("tEmployeeProject")EmployeeProjectExportParamVO searchVo);

	/**
	 * @Description: 更新项目档案商险状态
	 * @Author: hgw
	 * @Date: 2022/11/23 17:43
	 * @return: int
	 **/
	int updateEmployeeInsuranceStatus(@Param("emp") EmpIdCardAndDeptVo emp);

	/**
	 * @Description: 更新项目档案薪资状态
	 * @Author: hgw
	 * @Date: 2022/11/24 11:28
	 * @return: int
	 **/
	int updateEmployeeSalaryStatus(@Param("emp") EmpIdCardAndDeptVo emp);

	/**
	 * @Description: 每月1号更新档案薪资状态为无薪资
	 * @Author: hgw
	 * @Date: 2022/11/24 14:51
	 * @return: int
	 **/
	int everyMonthUpdateEmployeeSalaryStatus();

	/**
	 * @Description: 每天更新人员档案、项目档案的过期合同为2不在用
	 * @Author: hgw
	 * @Date: 2022/11/25 14:19
	 * @return: int
	 **/
	int everyDayUpdateEmployeContractStatus();

	/**
	 * 分页：B端获取登录用户对应单位的员工数据
	 * @Author fxj
	 * @Date 2020-08-25
	 * @UpdateDate 2021-08-09 wwg
	 * @param page
	 * @param query
	 **/
	IPage<BusinessEmployeeExtendListVO> getTEmployeeBusinessPage(Page page, @Param("query") THroBusinessUserQuery query);

	/**
	 * 根据条件查询，不分页
	 * @description: 根据条件查询，不分页
	 * @param query
	 * @return: java.util.List<com.yifu.cloud.v1.hrms.api.vo.basic.BusinessEmployeeExtentExcelVO>
	 * @author: wangweiguo
	 * @date: 2021/8/10
	 */
	List<BusinessEmployeeExtentExcelVO> getTEmployeeBusinessList(@Param("query") THroBusinessUserQuery query);

    int updateSocialAndFundStatusById(@Param("project")TEmployeeProject project);

    int updateChangeById(@Param("project")TEmployeeProject project);

	void updateContractStatus(@Param("empId") String empId, @Param("deptId") String deptId, @Param("status")int status);
}
