/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpEducation;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EducationSearchVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmpEducationExcelVO;
import com.yifu.cloud.plus.v1.yifu.archives.vo.EmpEducationUpdateExcelVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;

/**
 * 员工学历信息表
 *
 * @author fxj
 * @date 2022-06-18 09:39:46
 */
public interface TEmpEducationService extends IService<TEmpEducation> {

    void importEmpEducation(List<EmpEducationExcelVO> excelVOList, List<ErrorMessage> errorMessageList);

	R<Boolean> updateByIdDiy(TEmpEducation tEmpEducation);

	R<Boolean> saveDiy(TEmpEducation tEmpEducation);

	void importEmpEducationUpdate(List<EmpEducationUpdateExcelVo> excelVOList, List<ErrorMessage> errorMessageList);

    R<Boolean> insertEducationOfEmp(TEmpEducation education);

    IPage<TEmpEducation> pageDiy(Page page, EducationSearchVo tEmpEducation);

	List<TEmpEducation> getTEmpEducationNoPage(EducationSearchVo searchVo);

	R<List<ErrorMessage>> importEmpEducationDiy(InputStream inputStream);

	R<List<ErrorMessage>> importEmpEducationUpdateDiy(InputStream inputStream);

	void exportEmpEducation(EducationSearchVo searchVo, HttpServletResponse response);
}
