/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProject;
import com.yifu.cloud.plus.v1.yifu.archives.vo.*;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import org.apache.ibatis.annotations.Param;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * 项目档案表
 *
 * @author huyc
 * @date 2022-06-20 09:19:40
 */
public interface TEmployeeProjectService extends IService<TEmployeeProject> {

	/**
	 * @param tEmployeeProject
	 * @Description: 新增项目档案校验
	 * @Author: huyc
	 * @Date: 2022/6/21 10:30
	 * @return: R
	 **/
	R addCheck(TEmployeeProject tEmployeeProject);

	/**
	 * @param jsonObject
	 * @Description: 复档复项相关操作
	 * @Author: huyc
	 * @Date: 2022/6/21 10:30
	 * @return: R
	 **/
	R reEmpInfo(JSONObject jsonObject);

	/**
	 * @param tEmployeeProject
	 * @Description: 新增项目档案表
	 * @Author: huyc
	 * @Date: 2022/6/21 10:30
	 * @return: R
	 **/
	R saveEmp(TEmployeeProject tEmployeeProject);

	/**
	 * @param tEmployeeProject
	 * @Description: 修改项目档案表
	 * @Author: huyc
	 * @Date: 2022/6/21 10:30
	 * @return: R
	 **/
	R updateProject(TEmployeeProject tEmployeeProject);

	/**
	 * @param id
	 * @Description: 通过id删除项目档案
	 * @Author: huyc
	 * @Date: 2022/6/21 10:30
	 * @return: R
	 **/
	R removeProjectInfo(String id);

	/**
	 * @param tEmployeeProject
	 * @Description: 减项
	 * @Author: huyc
	 * @Date: 2022/6/21 10:30
	 * @return: R
	 **/
	R deleteEmpPro(TEmployeeProject tEmployeeProject);

	/**
	 * @param inputStream
	 * @Description: 批量减项
	 * @Author: huyc
	 * @Date: 2022/6/21 10:30
	 * @return: R
	 **/
	R<List<ErrorMessage>> batchDeleteEmpPro(InputStream inputStream);

	/**
	 * @param inputStream
	 * @param isAdd
	 * @Description: 批量新增项目档案
	 * @Author: huyc
	 * @Date: 2022/6/21 10:30
	 * @return: R
	 **/
	R<List<ErrorMessage>> importListAdd(InputStream inputStream, String isAdd);

	/**
	 * @param projectStatus 传0才过滤
	 * @param empId
	 * @Description: 根据员工id获取项目list
	 * @Author: hgw
	 * @Date: 2022/6/21 19:33
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProject>>
	 **/
	List<TEmployeeProject> getListByEmpId(String empId, int projectStatus);

	/**
	 * @param empId
	 * @param deptNo
	 * @Description: 获取档案下的项目信息
	 * @Author: hgw
	 * @Date: 2022/6/22 17:48
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProject>
	 **/
	List<TEmployeeProject> getListByEmpIdAndDeptNo(String empId, String deptNo);

	/**
	 * @param inputStream
	 * @Description: 批量更新项目档案
	 * @Author: huyc
	 * @Date: 2022/6/21 10:30
	 * @return: R
	 **/
	R<List<ErrorMessage>> importEmpProjectUpdate(InputStream inputStream);

	/**
	 * @param ids
	 * @Description: 批量删除项目档案
	 * @Author: huyc
	 * @Date: 2022/6/22 12:30
	 * @return: R
	 **/
	R<List<ErrorMessage>> batchRemoveByIds(List<String> ids);

	IPage<TEmployeeProject> getTEmployeeProjectInfoPage(Page page, TEmployeeProject vo);

	/**
	 * @param projectDTO
	 * @param exportFields
	 * @Description: 批量导出项目档案
	 * @Author: huyc
	 * @Date: 2022/6/23 10:30
	 * @return: R
	 **/
	void listExportProject(HttpServletResponse response, EmployeeProjectExportParamVO projectDTO, List<String> exportFields);
	/**
	 * @param employeeInfo
	 * @Description: 新增项目档案
	 * @Author: huyc
	 * @Date: 2022/6/23 18:06
	 **/
	void saveEmployeeProjectInfo(TEmployeeInfo employeeInfo);

	R getItemByEmpNo(String empIdcard, String empNo);

	/**
	 * @param empId
	 * @param deptId
	 * @Description: 获取项目信息
	 * @Author: hgw
	 * @Date: 2022/7/21 15:09
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeProject>
	 **/
	TEmployeeProject getByEmpIdAndDeptId(String empId, String deptId);

	R<Map<String, String>> getProjectByIdCard(String empIdCard);

    //获取员工编码
    String getEmpNo(String deptNo);

    Boolean updateProjectSocialFund(UpProjectSocialFundVo vo);

	/**
	 * @param vo
	 * @Description: 更新项目档案的商险状态
	 * @Author: hgw
	 * @Date: 2022/11/23 17:20
	 * @return: java.lang.Boolean
	 **/
	Boolean updateEmployeeInsuranceStatus(EmpStatusVo vo);

	/**
	 * @param vo
	 * @Description: 更新人员档案、项目档案的薪资状态
	 * @Author: hgw
	 * @Date: 2022/11/24 11:25
	 * @return: java.lang.Boolean
	 **/
	Boolean updateEmployeeSalaryStatus(EmpStatusVo vo);

	/**
	 * @Description: 每月1号定时更新项目档案薪资状态为否
	 * @Author: hgw
	 * @Date: 2022/11/24 14:55
	 * @return: void
	 **/
	void everyMonthUpdateEmployeeSalaryStatus();

	/**
	 * @Description: 每天更新人员档案、项目档案的过期合同为2不在用
	 * @Author: hgw
	 * @Date: 2022/11/24 14:55
	 * @return: void
	 **/
	void everyDayUpdateEmployeContractStatus();

	R<List<TSettleDomainDataVo>> selectSettleMentData(List<String> deptNoList);

	/**
	 * B端获取登录用户对应单位的员工数据
	 * @Author fxj
	 * @Date 2020-08-25
	 * @UpdaeDate 2021-08-09 wwg
	 * @param page
	 * @param query
	 * @return
	 **/
	IPage<BusinessEmployeeExtendListVO> getTEmployeeBusinessPage(Page<EmployeeBusinessVo> page, THroBusinessUserQuery query);

	/**
	 * 获取档案B端要求数据
	 * @Author fxj
	 * @Date 2020-05-25
	 * @param empId
	 * @return
	 **/
	EmployeeBusinessDetailVo getEmployeeBusinessInfoById(String empId, String settleDomain);

	R<EmployeeBusinessVo> getEmployeeBusinessVoById(String empId);

	/**
	 * b端人员信息导出
	 * @description: 导出：b端人员信息导出
	 * @param query
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.Boolean>
	 * @author: wangweiguo
	 * @date: 2021/8/10
	 */
	R<List<BusinessEmployeeExtentExcelVO>> exportByParams(THroBusinessUserQuery query);

    void updateChangeById(TEmployeeProject oldEmpProject);

    void updateContractStatus(String empId, String deptId, int status);
}
