package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.yifu.cloud.plus.v1.yifu.archives.entity.TAttaInfo;
import com.yifu.cloud.plus.v1.yifu.archives.service.FileUploadService;
import com.yifu.cloud.plus.v1.yifu.archives.service.TAttaInfoService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.OSSUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.FileVo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.net.URL;
import java.time.LocalDateTime;

@Service
@RequiredArgsConstructor
@Slf4j
public class FileUploadServiceImpl implements FileUploadService {

	private final OSSUtil ossUtil;

	private final TAttaInfoService tAttaInfoService;

	@Override
	public R<FileVo> uploadImg(MultipartFile file, String filePath, Integer type, String domain) throws IOException {
		if (null == file) {
			return R.failed("文件删除异常，请重新上传！");
		}
		String fileName = file.getOriginalFilename();
		if (Common.isEmpty(fileName)) {
			return R.failed("文件名不能为空！");
		}
		if (fileName.length() > 100) {
			return R.failed("文件名不能超过100个字符！");
		}
		//filePath不传默认存储空间的根目录
		//jpg,jpeg,png,bmp
		String key = "";
		if (Common.isNotNull(filePath)) {
			key = filePath + "/" + System.currentTimeMillis() + fileName;
		} else {
			key = System.currentTimeMillis() + fileName;
		}
		if (!Common.checkFile(key)) {
			return R.failed("非法上传类型！");
		}
		boolean flag = ossUtil.uploadFileByStream(file.getInputStream(), key, null);
		FileVo fileVo;
		TAttaInfo attaInfo;
		URL url;
		if (flag) {
			log.info("文件：" + fileName + "上传至存储空间" + ossUtil.getBucketName() + "成功！");
			attaInfo = initUnitAttaForInsert(fileName, key, file.getSize());
			attaInfo.setRelationType(String.valueOf(type));
			try {
				attaInfo.setDomainId(domain);
				attaInfo = tAttaInfoService.add(attaInfo);
			} catch (Exception e) {
				log.error("OSS文件上传接口异常：" + e.getMessage());
				ossUtil.deleteObject(null, key);
				return R.failed("fail:" + e.getMessage());
			}
			//有实体id则插入关系，用于编辑
			if (Common.isNotNull(domain)) {
				url = ossUtil.getObjectUrl(null, attaInfo.getAttaSrc());
				fileVo = new FileVo(attaInfo.getId(), attaInfo.getAttaName(), url.toString());
				return R.ok(fileVo, "success");
			}
			url = ossUtil.getObjectUrl(null, attaInfo.getAttaSrc());
			fileVo = new FileVo(attaInfo.getId(), attaInfo.getAttaName(), url.toString());
			return R.ok(fileVo, "success");
		} else {
			return R.failed("fail:上传失败");
		}
	}

	/**
	 * 对象初始化
	 * @param fileName
	 * @param key
	 * @param fileSize
	 * @return
	 */
	private TAttaInfo initUnitAttaForInsert(String fileName, String key, long fileSize) {
		TAttaInfo unitAtta = new TAttaInfo();
		char slash = '/';
		char point = '.';
		if (fileName.lastIndexOf(slash) >= 0) {
			unitAtta.setAttaName(fileName.substring(fileName.lastIndexOf(slash)));
		} else {
			unitAtta.setAttaName(fileName);
		}
		unitAtta.setAttaSize(fileSize);
		unitAtta.setAttaSrc(key);
		if (key.lastIndexOf(point) >= 0) {
			unitAtta.setAttaType(key.substring(key.lastIndexOf(point)));
		}
		unitAtta.setCreateTime(LocalDateTime.now());
		return unitAtta;
	}
}
