package com.yifu.cloud.plus.v1.business.vo.vacation;


import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @description: 假勤信息表 分页查询展示 vo
 * @author: wangweiguo
 * @date: 2021-08-20
*/
@Setter
@Getter
@ToString
public class TVacationInfoVO implements Serializable  {
    /**
     * 主键
     */
	@Schema(description = "主键")
    private String id;

    /**
     * b端员工工号
     */
	@Schema(description = "电信工号")
	private String businessTelecomNumber;

    /**
     * 人员姓名
     */
	@Schema(description = "人员姓名")
	private String empName;

    /**
     * 身份证号码
     */
	@Schema(description = "身份证号码")
	private String empIdcard;

    /**
     * 部门id
     */
	@Schema(description = "部门id")
	private Integer departId;

    /**
     * 部门名称
     */
	@Schema(description = "部门名称")
	private String departName;

    /**
     * 假勤状态
     */
	@Schema(description = "假勤状态 0待休 1休假中 2到期待销假 3已销假")
	private String vacationStatus;

    /**
     * b端岗位
     */
	@Schema(description = "岗位")
	private String businessPost;

    /**
     * 假勤类型（字典值）
     */
	@Schema(description = "假勤类型（字典值）")
	private String vacationType;

    /**
     * 假勤开始时间
     */
	@Schema(description = "假勤开始时间")
	private LocalDateTime vacationStartTime;

    /**
     * 假勤结束时间
     */
	@Schema(description = "假勤结束时间")
	private LocalDateTime vacationEndTime;

    /**
     * 假勤时长
     */
	@Schema(description = "假勤时长")
	private BigDecimal vacationDuration;

    /**
     * 假勤事由
     */
	@Schema(description = "假勤事由")
	private String vacationReason;

    /**
     * 假勤实际结束时间
     */
	@Schema(description = "假勤实际结束时间")
	private LocalDateTime acturalVacationEndTime;

    /**
     * 销假说明
     */
	@Schema(description = "销假说明")
	private String vacationNote;

    /**
     * 剩余年假时长
     */
	@Schema(description = "剩余年假时长")
	private BigDecimal vacationNotUsedDuration;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}

