package com.yifu.cloud.plus.v1.business.controller.cert;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.cert.TUpdateRecord;
import com.yifu.cloud.plus.v1.business.service.cert.TUpdateRecordService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


/**
 * 证书变更记录表
 *
 * @author fxj
 * @date 2021-08-16 15:34:16
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tupdaterecord")
@Tag(name = "证书变更记录表")
public class TUpdateRecordController {

    private final TUpdateRecordService tUpdateRecordService;

    /**
     * 简单分页查询
     *
     * @param page      分页对象
     * @param updateRecord 证书变更记录表
     * @return
     */
    @Operation(summary = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TUpdateRecord>> getTCertInfoPage(Page<TUpdateRecord> page, TUpdateRecord updateRecord) {
        return new R<>(tUpdateRecordService.getTUpdateRecordPage(page, updateRecord));
    }


    /**
     * 通过id查询单条记录
     *
     * @param domainId
     * @return R
     */
    @Operation(summary = "通过实体类ID查询对应变更记录信息")
    @GetMapping("/getRecordsByDomainId")
    public R<List<TUpdateRecord>> getById(@PathVariable("domainId") String domainId) {
        return tUpdateRecordService.getRecordsByDomainId(domainId);
    }

}
