package com.yifu.cloud.plus.v1.business.controller.settle;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.settle.TBusSettle;
import com.yifu.cloud.plus.v1.business.service.settle.TBusSettleService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.time.LocalDateTime;
import java.util.List;


/**
 * B端结算表
 *
 * @author hgw
 * @date 2021-08-16 15:58:09
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tbussettle")
@Tag(name = "B端结算表")
public class TBusSettleController {

	private final TBusSettleService tBusSettleService;

	/**
	 * 简单分页查询
	 *
	 * @param page       分页对象
	 * @param tBusSettle B端结算表
	 * @return
	 */
	@Operation(summary = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TBusSettle>> getTBusSettlePage(Page<TBusSettle> page, TBusSettle tBusSettle) {
		return new R<>(tBusSettleService.getTBusSettlePage(page, tBusSettle));
	}

	/**
	 * 列表，可用来查重
	 *
	 * @param tBusSettle B端结算表
	 * @return
	 */
	@Operation(summary = "列表，可用来查重")
	@GetMapping("/getTBusSettleList")
	public R<List<TBusSettle>> getTBusSettleList(TBusSettle tBusSettle) {
		return new R<>(tBusSettleService.getTBusSettleList(tBusSettle));
	}


	/**
	 * 通过id查询单条记录
	 *
	 * @param id
	 * @return R
	 */
	@Operation(summary = "id查询")
	@GetMapping("/{id}")
	public R<TBusSettle> getById(@PathVariable("id") String id) {
		return new R<>(tBusSettleService.getById(id));
	}

	/**
	 * 新增记录
	 *
	 * @param tBusSettle
	 * @return R
	 */
	@Operation(summary = "新增(yifu-hro-business:tbussettle_add)")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('yifu-hro-business:tbussettle_add')")
	public R<Boolean> save(@RequestBody TBusSettle tBusSettle) {
		YifuUser user = SecurityUtils.getUser();
		if (user != null && user.getId() != null) {
			tBusSettle.setCreateTime(LocalDateTime.now());
			tBusSettle.setCreateUserId(String.valueOf(user.getId()));
			tBusSettle.setCreateUserName(user.getNickname());
			return new R<>(tBusSettleService.save(tBusSettle));
		} else {
			return R.failed("未获取到登录人信息！");
		}
	}

	/**
	 * 修改记录
	 *
	 * @param tBusSettle
	 * @return R
	 */
	@Operation(summary = "修改(yifu-hro-business:tbussettle_edit)")
	@SysLog("修改B端结算表")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('yifu-hro-business:tbussettle_edit')")
	public R<Boolean> update(@RequestBody TBusSettle tBusSettle) {
		return new R<>(tBusSettleService.updateById(tBusSettle));
	}

	/**
	 * 通过id删除一条记录
	 *
	 * @param id
	 * @return R
	 */
	@Operation(summary = "假删除(yifu-hro-business:tbussettle_del)")
	@SysLog("假删除B端结算表")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('yifu-hro-business:tbussettle_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		TBusSettle tBusSettle = new TBusSettle();
		tBusSettle.setId(id);
		tBusSettle.setDeleteFlag(CommonConstants.ONE_INT);
		return new R<>(tBusSettleService.updateById(tBusSettle));
	}

	/**
	 * @param file zip文件包
	 * @description: 解析zip文件包中的多个附件，并生成结算记录
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.Boolean>
	 * @author: wangweiguo
	 * @date: 2021/8/19
	 */
	@Operation(summary = "导入：(yifu-hro-business:import_zip)")
	@PostMapping("/importZip")
	@PreAuthorize("@pms.hasPermission('yifu-hro-business:import_zip')")
	//@ApiImplicitParam(value = "zip文件", name = "file", paramType = "form", required = true)
	public R<Boolean> importZip(@RequestParam("file") MultipartFile file) {
		return this.tBusSettleService.importZip(file);
	}

}
