package com.yifu.cloud.plus.v1.business.mapper.salary;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.salary.TSalaryStatisticsDepart;
import com.yifu.cloud.plus.v1.business.query.salary.TSalaryCurDepartQuery;
import com.yifu.cloud.plus.v1.business.query.salary.TSalaryStatisticsDepartPageQuery;
import com.yifu.cloud.plus.v1.business.query.salary.TSalaryStatisticsDepartQuery;
import com.yifu.cloud.plus.v1.business.vo.salary.TSalaryStatisticsDepartVO;
import com.yifu.cloud.plus.v1.business.vo.salary.TSalaryTotalVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @description: 部门薪资变动统计表 mapper
 * @Entity com.yifu.cloud.v1.hrobusiness.api.entity.salary.TSalaryStatisticsDepart
 * @author: wangweiguo
 * @date: 2021-09-06
*/
@Mapper
public interface TSalaryStatisticsDepartMapper extends BaseMapper<TSalaryStatisticsDepart> {

    Page<TSalaryStatisticsDepartVO> getListByPage(Page<TSalaryStatisticsDepartVO> page, @Param("query") TSalaryStatisticsDepartPageQuery query);

    List<TSalaryStatisticsDepartVO> getListByPage(@Param("query") TSalaryStatisticsDepartQuery query);

    TSalaryTotalVO sumSalaryDepart(@Param("query") TSalaryStatisticsDepartQuery query);

    TSalaryTotalVO getCurDepartSumData(@Param("query") TSalaryCurDepartQuery query);

    TSalaryStatisticsDepartVO getCurDepartData(@Param("query") TSalaryCurDepartQuery query);
}




