package com.yifu.cloud.plus.v1.check.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;


/**
 * 实名校验限定调用API的条数表
 *
 * @author hgw
 * @date 2022-6-10 11:07:37
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("t_can_check")
@Tag(name = "可以校验")
public class TCanCheck extends Model<TCanCheck> {
     private static final long serialVersionUID = 1L;
     /**
      * 主键
      */
     @TableId(type = IdType.ASSIGN_ID)
     @Schema(description = "主键")
     private String id;

     /**
      * 0不可，1可以校验
      */
     @NotNull(message = "0不可，1可以校验不能为空")
     @Schema(description = "0不可，1可以校验")
     private Integer canCheck;
}
