package com.yifu.cloud.plus.v1.yifu.common.core.exception;

/**
 * 错误编码
 *
 * @author lengleng
 * @date 2022/3/30
 */
public interface ErrorCodes {

	/**
	 * 系统编码错误
	 */
	String SYS_PARAM_CONFIG_ERROR = "sys.param.config.error";

	/**
	 * 系统内置参数不能删除
	 */
	String SYS_PARAM_DELETE_SYSTEM = "sys.param.delete.system";

	/**
	 * 用户已存在
	 */
	String SYS_USER_USERNAME_EXISTING = "sys.user.username.existing";

	/**
	 * 用户原密码错误，修改失败
	 */
	String SYS_USER_UPDATE_PASSWORDERROR = "sys.user.update.passwordError";

	/**
	 * 用户信息为空
	 */
	String SYS_USER_USERINFO_EMPTY = "sys.user.userInfo.empty";

	/**
	 * 获取当前用户信息失败
	 */
	String SYS_USER_QUERY_ERROR = "sys.user.query.error";

	/**
	 * 部门名称不存在
	 */
	String SYS_DEPT_DEPTNAME_INEXISTENCE = "sys.dept.deptName.inexistence";

	/**
	 * 岗位名称不存在
	 */
	String SYS_POST_POSTNAME_INEXISTENCE = "sys.post.postName.inexistence";

	/**
	 * 岗位名称或编码已经存在
	 */
	String SYS_POST_NAMEORCODE_EXISTING = "sys.post.nameOrCode.existing";

	/**
	 * 角色名称不存在
	 */
	String SYS_ROLE_ROLENAME_INEXISTENCE = "sys.role.roleName.inexistence";

	/**
	 * 角色名或角色编码已经存在
	 */
	String SYS_ROLE_NAMEORCODE_EXISTING = "sys.role.nameOrCode.existing";

	/**
	 * 系统内置菜单不允许删除
	 */
	String SYS_MENU_DELETE_SYSTEM = "sys.menu.delete.system";

	/**
	 * 菜单上级菜单不可为数据权限配置类菜单
	 */
	String SYS_MENU_ADD_PARENT_ERROR = "sys.menu.add.parent.error";

	/**
	 * 菜单存在下级节点 删除失败
	 */
	String SYS_MENU_DELETE_EXISTING = "sys.menu.delete.existing";

	/**
	 * 系统内置字典不允许删除
	 */
	String SYS_DICT_DELETE_SYSTEM = "sys.dict.delete.system";

	/**
	 * 系统内置字典不能修改
	 */
	String SYS_DICT_UPDATE_SYSTEM = "sys.dict.update.system";

	/**
	 * 验证码发送频繁
	 */
	String SYS_APP_SMS_OFTEN = "sys.app.sms.often";

	/**
	 * 手机号未注册
	 */
	String SYS_APP_PHONE_UNREGISTERED = "sys.app.phone.unregistered";

	/**
	 * 字典存在下级节点 删除失败
	 */
	String SYS_DICT_DELETE_EXISTING = "sys.dict.delete.existing";

	/**
	 * 系统内置角色不允许删除
	 */
	String SYS_ROLE_DELETE_SYSTEM = "sys.role.delete.system";

	/**
	 * 该角色下还有关联的用户，请先将用户转移到其他角色!
	 */
	String SYS_ROLE_DELETE_EXIST_USER = "sys.role.delete.existing.user";

	/**
	 * 系统内置角色不能修改
	 */
	String SYS_ROLE_UPDATE_SYSTEM = "sys.role.update.system";

	/**
	 * 系统内置用户不允许删除
	 */
	String SYS_USER_DELETE_SYSTEM = "sys.user.delete.system";

	/**
	 * 系统内置用户不允许修改
	 */
	String SYS_USER_UPDATE_SYSTEM = "sys.user.update.system";

	/**
	 * 已存在对应标识的角色
	 */
	String SYS_ROLE_UPDATE_ERROR_CODE_EXIST= "sys.role.update.error.code.exist";
	/**
	 * 已存在对应名称的菜单
	 */
	String SYS_MENU_ADD_NAME_EXIST = "sys_menu_add_name_exist";

	/**
	 * 已存在对应名称的角色
	 */
	String SYS_ROLE_UPDATE_ERROR_NAME_EXIST ="sys.role.update.error.name.exist";

	/**
	 * 已存在对应编码的字典
	 */
	String SYS_DICT_ADD_TYPE_EXISTS = "sys.dict.add.type.exist";

	/**
	 * 已存在对应值的字典项
	 */
	String SYS_DICT_ITEM_ADD_VALUE_EXIST = "sys.dict.item.add.value.exist";
	/**
	 * 存在下级字典，禁止删除
	 */
	String SYS_DICT_DELETE_EXIST_CHILD = "sys.dict.delete.exist.child";

	/**
	 * 存在下级字典项值，禁止删除
	 */
	String SYS_DICT_ITEM_DELETE_EXIST_CHILD = "sys.dict.item.delete.exist.child";

	/**
	 * 已存在对应伤残病名称的数据
	 */
    String ARCHIVES_EMP_DISABILITY_NAME_EXISTING = "archives.emp.disability.name.existing";

	/**
	 * 已存在对应身份证的家庭成员信息
	 */
	String ARCHIVES_EMP_FAMILY_NAME_EXISTING = "archives.emp.family.name.existing";

	/**
	 * 无对应身份证的员工信息
	 */
	String ARCHIVES_EMP_NOT_EXIST = "archives.emp.not.exist";

	/**
	 * 员工已减档
	 */
	String ARCHIVES_EMP_REDUCED = "archives.emp.reduced";
	/**
	 * 已存在对应身份证的工作记录信息
	 */
	String ARCHIVES_EMP_WORK_RECORD_EXISTING = "archives.emp.work.record.existing";

	/**
	 * 已存在该员工对应学历名称的学历信息
	 */
	String ARCHIVES_EMP_EDUCATION_EXISTING = "archives.emp.education.existing";
	/**
	 * 参数不可为空
	 */
	String PARAM_NOT_EMPTY = "param.not.empty";
	/**
	 * 校验请求异常
	 */
	String CHECKS_MOBILE_REQUEST_ERROR = "checks.mobile.request.error";
	/**
	 * 单次号码状态校验请求上限100
	 */
	String CHECKS_MOBILE_REQUEST_LIMIT_HUNDRED = "checks.mobile.request.limit.hundred";
	/**
	 * 银行卡号校验传参有误：姓名、身份证号、银行卡号 必填
	 */
	String CHECKS_BANK_NO_REQUEST_PARAM_ERROR = "checks.bank.no.request.param.error";
	/**
	 * 存在已减档的档案和已减项的项目，禁止导入
	 */
	String CHECKS_EMP_PROJECT_ERROR = "checks.emp.project.error";
	/**
	 * 存在已减档的档案，禁止导入
	 */
	String CHECKS_REDUCE_EMP_ERROR = "checks.reduce.emp.error";
	/**
	 * 该人员暂无档案信息，请先至“在档人员”处建档
	 */
	String CHECKS_EXIT_EMPPROJECT_ERROR = "checks.exit.empproject.error";
	/**
	 * 存在已减项的项目，禁止导入
	 */
	String CHECKS_REDUCE_PROJECT_ERROR = "checks.reduce.project.error";
	/**
	 * 人员不在该项目，无法更新
	 */
	String CHECKS_EMP_EXIT_ERROR = "checks.emp.exit.error";
	/**
	 * 人员已减项，无法更新
	 */
	String CHECKS_EMP_DELETE_ERROR = "checks.emp.delete.error";
	// 该人员已存在，禁止重复添加
	String ARCHIVES_IMPORT_EMP_IDCARD_EXISTING = "archives.import.emp.idCard.existing";

	// 手机号校验错误
	String ARCHIVES_IMPORT_EMP_PHONE_CHECK_ERROR = "archives.import.emp.phone.check.error";

	// 手机号已被其他身份证使用
	String ARCHIVES_IMPORT_EMP_PHONE_EXIST_ERROR = "archives.import.emp.phone.exist.error";
	// 婚姻状况在字典中未找到
	String ARCHIVES_IMPORT_EMP_MARRIED_ERROR = "archives.import.emp.married.error";
	// 民族在字典中未找到
	String ARCHIVES_IMPORT_EMP_NATIONAL_ERROR = "archives.import.emp.national.error";
	// 政治面貌在字典中未找到
	String ARCHIVES_IMPORT_EMP_POLITICAL_ERROR = "archives.import.emp.political.error";
	// 户口性质在字典中未找到
	String ARCHIVES_IMPORT_EMP_REGISTYPE_ERROR = "archives.import.emp.registype.error";
	// 最高学历在字典中未找到
	String ARCHIVES_IMPORT_EMP_EDUCATION_ERROR = "archives.import.emp.education.error";
	// 员工类型在字典中未找到
	String ARCHIVES_IMPORT_EMP_NATRUE_ERROR = "archives.import.emp.natrue.error";
	// 户籍所在地未找到区域
	String ARCHIVES_IMPORT_EMP_AREA_ERROR = "archives.import.emp.area.error";
	// 档案所在地未找到区域
	String ARCHIVES_IMPORT_EMP_FILE_AREA_ERROR = "archives.import.emp.file.area.error";
	// 大专及以上，最高学历必填
	String ARCHIVES_IMPORT_EMP_HIGH_EDUCATION_ERROR = "archives.import.emp.high.education.error";
	// 该人员未在档，请核实
	String ARCHIVES_IMPORT_EMP_NOT_EXISTS = "archives.import.emp.not.exists";
	// 存在已减档的档案，禁止导入
	String ARCHIVES_IMPORT_EMP_ERROR_STATUS_EXISTS = "archives.import.emp.error.status.exists";
	// 身份证必填
	String ARCHIVES_IMPORT_EMP_IDCARD_MUST = "archives.import.emp.idCard.must";
	String ARCHIVES_IMPORT_EMP_EMPNAME_MUST = "archives.import.emp.empName.must";
	// 减档原因必填
	String ARCHIVES_IMPORT_EMP_LEAVEREASON_MUST = "archives.import.emp.leaveReason.must";
	String ARCHIVES_IMPORT_EMP_LEAVEREMARK_LENGTH = "archives.import.emp.leaveRemark.length";
	String ARCHIVES_IMPORT_EMP_HAVE_PROJECT = "archives.import.emp.have.project";
	String ARCHIVES_IMPORT_EMP_EMAIL_CHECK = "archives.import.emp.email.check";
	String ARCHIVES_IMPORT_EMP_EMAIL_LENGTH = "archives.import.emp.email.length";
	// 减项原因在字典中未找到
	String ARCHIVES_IMPORT_EMP_REDUCE_ERROR = "archives.import.emp.reduce.error";
	/**
	 * 项目档案状态为已审核，禁止删除
	 */
	String CHECKS_PROJECT_DELETE_ERROR = "checks.project.delete.error";

	/**
	 * 已存在对应身份证的证书信息
	 */
	String ARCHIVES_EMP_CERTIFICATE_NAME_EXISTING = "archives.emp.certificate.name.existing";
	/**
	 * 待划转员工已在目标项目下不可划转
	 */
	String CHECKS_CHANGE_EMP_PROJECT = "checks.change.emp.project";
	/**
	 * 导入的文件格式不正确
	 */
	String IMPORT_FILE_TYPE_ERROR = "import.file.type.error";
	/**
	 * 申请年份不可为未来年份
	 */
	String ARCHIVES_EMP_CERTIFICATE_DECLARE_YEAR_ERROR = "archives.emp.certificate.declare.year.error";
	/**
	 * 对应项目编码无项目档案信息，请核实后导入
	 */
	String ARCHIVES_PROJECT_EMP_NOT_EXIST = "archives.project.emp.not.exist";
	/**
	 * 人员在该项目下存在进行中/未完结的服务
	 */
	String ARCHIVES_PROJECT_CHANGE_NOT_EXIST = "archives.project.change.not.exist";
	/**
	 * 人员在该项目下存在存在在用或待审核、待提交的合同，不允许减项
	 */
	String ARCHIVES_PROJECT_CHANGE_CONTRACT_EXIST = "archives.project.change.contract.exist";
	/**
	 * 人员在原项目中存在在途的服务，请先终止后，再进行划转
	 */
	String QT_PROJECT_CHANGE_NOT_EXIST = "qt.project.change.not.exist";
	/**
	 * 未找到对应的新项目或者新项目已停止合作，请核实
	 */
	String PROJECT_NEW_SEARCH_NOT_EXIST = "project.new.search.not.exist";
	/**
	 * 未找到对应的项目或者项目已停止合作，请核实
	 */
	String PROJECT_SEARCH_NOT_EXIST = "project.search.not.exist";
	/**
	 * 不良记录费用损失和其他损失不可同时为空
	 */
	String ARCHIVES_PROJECT_EMP_LOSE_FEE_NOT_EMPTY = "archives.project.emp.lose.fee.not.empty";
	/**
	 * 划转起始月不能为空
	 */
	String CHANGE_START_MONTH_EXIT = "change.strat.month.exit";
	/**
	 * 划转起始月要小于等于当前月
	 */
	String CHANGE_LESS_MONTH_EXIT = "change.less.month.exit";
	/**
	 * 未找到该人员的项目档案，请核实
	 */
	String PROJECT_PERSON_SEARCH_EXIT = "project.person.search.exit";
	/**
	 * 该人员项目档案已减项，不允许划转
	 */
	String PROJECT_PERSON_DELETE_EXIT = "project.person.delete.exit";
	/**
	 * 派单员工合同相关信息不可为空
	 */
    String EMP_DISPATCH_CONTRACT_NOT_EMPTY = "emp.dispatch.contract.not.empty";
	/**
	 * 派单员工社保相关信息不可为空
	 */
	String EMP_DISPATCH_SOCIAL_NOT_EMPTY = "emp.dispatch.social.not.empty";

	/**
	 * 派单公积金信息不可为空
	 */
	String EMP_DISPATCH_FUND_NOT_EMPTY = "emp.dispatch.fund.not.empty";

	/**
	 * 新增异常：已存在社保数据
	 */
	String EMP_DISPATCH_SOCIAL_EXISTING = "emp.dispatch.social.existing";
	/**
	 * 新增异常：存在办理成功未派减的工伤社保数据
	 */
	String EMP_DISPATCH_SOCIAL_INJURY_EXISTING = "emp.dispatch.social.injury.existing";
	/**
	 * 新增异常：存在办理成功未派减的五险社保数据，禁止新增工伤
	 */
	String EMP_DISPATCH_SOCIAL_NOT_REDUCE = "emp.dispatch.social.not.reduce";
	/**
	 * 新增异常：存在办理成功未派减的工伤社保数据，禁止新增五险
	 */
	String EMP_DISPATCH_SOCIAL_INJURY_NOT_REDUCE = "emp.dispatch.social.injury.not.reduce";
	/**
	 * 新增异常：未找到对应社保户名称的可用基数配置信息
	 */
	String EMP_DISPATCH_SOCIAL_HOLD_NOT_EXIST = "emp.dispatch.social.hold.not.exist";
	/**
	 * 新增异常：备案基数不可为空
	 */
	String EMP_DISPATCH_SOCIAL_RECORD_BASE_NOT_EXIST = "emp.dispatch.social.record.base.not.exist";

	/**
	 * 新增异常：未找到对应公积金户名称的可用基数配置信息
	 */
	String EMP_DISPATCH_FUND_HOLD_NOT_EXIST = "emp.dispatch.fund.hold.not.exist";
	/**
	 * 新增异常：未找到对应公积金比例配置信息
	 */
	String EMP_DISPATCH_FUND_PERCENT_NOT_EXIST = "emp.dispatch.fund.percent.not.exist";
	/**
	 * 新增异常：必须派单社保或公积金，不支持单派档案
	 */
	String EMP_DISPATCH_SOCIAL_AND_FUND_NOT_EMPTY = "emp.dispatch.social.and.fund.not.empty";
	/**
	 * 新增异常：未找到对应项目编码信息
	 */
	String EMP_DISPATCH_PROJECT_NOT_FOUND = "emp.dispatch.project.not.found";

	/**
	 * 新增异常：派单新增档案失败，请重试
	 */
	String EMP_DISPATCH_ADD_EMP_ERROR = "emp.dispatch.add.emp.error";
	/**
	 * 新增异常：派单新增合同失败，请重试
	 */
	String EMP_DISPATCH_ADD_CONTRACT_ERROR="emp.dispatch.add.contract.error";

	/**
	 * 新增异常：派单新增项目档案失败，请重试
	 */
	String EMP_DISPATCH_ADD_PROJECT_ERROR="emp.dispatch.add.project.error";
	/**
	 * 新增异常：已存在公积金数据
	 */
	String EMP_DISPATCH_FUND_EXISTING = "emp.dispatch.fund.existing";
	/**
	 * 派减异常： 未找到社保及公积金信息
	 */
	String EMP_DISPATCH_SOCIAL_FUND_NOT_EMPTY = "emp.dispatch.social.fund.not.empty";
	/**
	 * 派减异常： 请选择社保停缴日期或公积金停缴日期
	 */
	String EMP_DISPATCH_REDUCE_SOCIAL_FUND_NOT_EMPTY = "emp.dispatch.reduce.social.fund.not.empty";
	/**
	 * 派减异常： 未找到办理成功的社保状态，或社保派减中，请确认后重试
	 */
	String EMP_DISPATCH_REDUCE_SOCIAL_STATUS_ERROR = "emp.dispatch.reduce.social.status.error";
	/**
	 * 派减异常： 未找到办理成功的公积金状态，或公积金派减中，请确认后重试
	 */
	String EMP_DISPATCH_REDUCE_FUND_STATUS_ERROR = "emp.dispatch.reduce.fund.status.error";
	/**
	 * 派减异常： 本次派增已存在对应身份证号的派减记录
	 */
	String EMP_DISPATCH_REDUCE_EXISTS = "emp.dispatch.reduce.exists";
	/**
	 * 无可派单项，请确认后再次操作
	 */
	String EMP_DISPATCH_ITEM_EMPTY_EXISTS = "emp.dispatch.item.empty.exists";
	/**
	 * 当前社保导入队列不足或者数据量过大，请稍后重试！
	 */
	String SOCIALINFO_LIST_NUM_LARGE = "socialinfo.list.num.large";
	/**
	 * 派增异常： 自定义缴纳养老基数不可为空
	 */
	String EMP_DISPATCH_SOCIAL_DIY_NOT_EMPTY = "emp.dispatch.social.diy.not.empty";
	/**
	 *  派增异常： 自定义缴纳养老基数或养老起缴日期不可为空
	 */
	String EMP_DISPATCH_SOCIAL_DIY_MEDICAL_NOT_EMPTY = "emp.dispatch.social.diy.medical_not.empty";

	/**
	 * 派增异常： 对应项目编码的项目档案已减项，请去项目档案处复项
	 */
	String EMP_DISPATCH_EMP_PROJECT_NOT_USED = "emp.dispatch.emp.project.not.used";
	/**
	 * 派增异常： 对应身份证的人员档案已减档
	 */
	String EMP_DISPATCH_EMP_NOT_USED = "emp.dispatch.emp.not.used";
	/**
	 * 派增异常： 社保派单基数不可小于最低基数且不可大于最高基数
	 */
	String EMP_DISPATCH_SOCIAL_LIMIT_ERROR = "emp.dispatch.social.limit.error";
	/**
	 * 派增异常： 社保派单养老基数不可小于最低基数且不可大于最高基数
	 */
	String YL_DISPATCH_SOCIAL_LIMIT_ERROR = "yl.dispatch.social.limit.error";
	/**
	 * 派增异常： 社保派单医疗基数不可小于最低基数且不可大于最高基数
	 */
	String YB_DISPATCH_SOCIAL_LIMIT_ERROR = "yb.dispatch.social.limit.error";
	/**
	 * 派增异常： 社保派单工伤基数不可小于最低基数且不可大于最高基数
	 */
	String GS_DISPATCH_SOCIAL_LIMIT_ERROR = "gs.dispatch.social.limit.error";
	/**
	 * 派增异常： 社保派单失业基数不可小于最低基数且不可大于最高基数
	 */
	String SY_DISPATCH_SOCIAL_LIMIT_ERROR = "sy.dispatch.social.limit.error";
	/**
	 * 派增异常： 社保派单生育基数不可小于最低基数且不可大于最高基数
	 */
	String BIR_DISPATCH_SOCIAL_LIMIT_ERROR = "bir.dispatch.social.limit.error";
	/**
	 * 派增异常： 社保派单大病基数不可小于最低基数且不可大于最高基数
	 */
	String DB_DISPATCH_SOCIAL_LIMIT_ERROR = "db.dispatch.social.limit.error";
	/**
	 * 派增异常： 公积金派单基数不可小于最低基数且不可大于最高基数
	 */
	String EMP_DISPATCH_FUND_LIMIT_ERROR = "emp.dispatch.fund.limit.error";
	/**
	 * 派增异常： 社保各项基数不一致，委托备注必填
	 */
	String EMP_DISPATCH_SOCIAL_BASE_LIMIT_ERROR = "emp.dispatch.social.base.limit.error";
	/**
	 * 派增异常： 社保各项起缴日不一致，委托备注必填
	 */
	String EMP_DISPATCH_SOCIAL_DATE_LIMIT_ERROR = "emp.dispatch.social.date.limit.error";
	/**
	 * 派增异常： 社保各项起缴日不一致，委托备注必填
	 */
	String EMP_DISPATCH_SOCIAL_DATE_LIMIT_ERROR2 = "emp.dispatch.social.date.limit.error2";
	/**
	 * 派增异常： 社保各项起缴月份需为可补缴月份，请确认后操作
	 */
	String EMP_DISPATCH_SOCIAL_START_IS_ERROR = "emp.dispatch.social.start.is.error";
	/**
	 * 派增异常： 公积金起缴月份需为可补缴月份，请确认后操作
	 */
	String EMP_DISPATCH_FUND_DATE_LIMIT_ERROR = "emp.dispatch.fund.start.is.error";
	/**
	 * 派增异常： 合同起缴时间、合同类型、签订期限必填不可为空
	 */
	String EMP_DISPATCH_EMP_CONTRACT_NOT_EMPTY = "emp.dispatch.emp.contract.not.empty";
	/**
	 * 派增异常： 系统无对应项目档案，档案相关同色字段必填
	 */
	String EMP_DISPATCH_EMP_NOT_EMPTY = "emp.dispatch.emp.not.empty";
	/**
	 * 派增异常：对应项目编码的项目已冻结/已停止合作
	 */
	String EMP_DISPATCH_SETTLEDOMAIN_STOP = "emp.dispatch.settleDomain.stop";
	/**
	 * 派减异常： 无对应项目编码的社保信息
	 */
	String EMP_DISPATCH_REDUCE_SOCIAL_DEPARTNO_ERROR = "emp.dispatch.reduce.social.depart.no.error";
	/**
	 * 派减异常： 无对应项目编码的公积金信息
	 */
	String EMP_DISPATCH_REDUCE_FUND_DEPARTNO_ERROR = "emp.dispatch.reduce.fund.depart.no.error";
	/**
	 * 派增异常： 单派工伤其他起缴日期不可填写
	 */
	String EMP_DISPATCH_SOCIAL_DIY_INJURY_ERROR = "emp.dispatch.social.diy.injury.error";
	/**
	 * 派增异常： 已存在对应手机号码的在用员工档案
	 */
	String EMP_DISPATCH_EMP_MOBILE_REPEAT = "emp.dispatch.emp.mobile.repeat";
	/**
	 * 派增异常： 同一身份证不可分多行派单
	 */
	String EMP_DISPATCH_EXIST = "emp_dispatch_exist";
	/**
	 * 派增异常： 已存在兼职工伤，请派减后再派增五险
	 */
	String EMP_DISPATCH_SOCIAL_INJURY_EXISTING_LIMIT = "emp.dispatch.social.injury.existing.limit";
	/**
	 * 派增异常： 失败项重新派单社保户与已有社保户不一致
	 */
	String EMP_DISPATCH_SOCIAL_HOLD_NOT_SAME = "emp.dispatch.social.hold.same";
	/**
	 * 派增异常： 失败项重新派单缴纳方式不可变更
	 */
	String EMP_DISPATCH_SOCIAL_PAYMENT_TYPE_NOT_SAME = "emp.dispatch.social.payment.type.same";
	/**
	 * 社保户不能为空
	**/
	String SOCIAL_HOLD_IS_EMPTY = "social.hold.is.empty";
	/**
	 * 公积金户不能为空
	 **/
	String FUND_HOLD_IS_EMPTY = "fund.hold.is.empty";
	/**
	 * 信息校验通过，但其他行存在问题数据，请调整后，统一减档
	 **/
	String ARCHIVES_IMPORT_EMP_TRUE = "archives.import.emp.true";

	/**
	 * 派增异常： 固定期限合同截止日期不可为空
	**/
	String EMP_DISPATCH_EMP_CONTRACT_END_NOT_EMPTY = "emp.dispatch.emp.contract.end.not.empty";
	/**
	 * 派增异常： 合同类型为其他时业务细分不可为空
	 **/
	String EMP_DISPATCH_EMP_CONTRACT_SUB_NAME_NOT_EMPTY = "emp.dispatch.emp.contract.sub.name.not.empty";

	/**
	 * 公积金办理：无办理权限或无可需要办理的公积金数据
	 */
	String FUND_IMPORT_HANDLE_NOT_EXITS = "fund.import.handle.not.exits";
	/**
	 * 公积金办理：办理失败，失败原因必填
	 */
    String FUND_IMPORT_HANDLE_REASON_NOT_EMPY = "fund_import_handle_reason_not_empty";
	/**
	 * 社保办理：任一险种办理失败，失败原因必填
	 */
	String SOCIAL_IMPORT_HANDLE_REASON_NOT_EMPY = "social_import_handle_reason_not_empty";
	/**
	 * 社保办理失败，必须办理其中一个险种
	 */
	String SOCIAL_IMPORT_HANDLE_NOT_EMPY = "social_import_handle_not_empty";
	/**
	 * 社保办理：无办理权限或无可需要办理的社保数据
	 */
	String SOCIAL_IMPORT_HANDLE_NOT_EXITS = "social.import.handle.not.exits";
	/**
	 * 社保办理：该数据已处理，请勿重复操作
	 */
	String SOCIAL_IMPORT_SAME_INFO = "social.import.same.info";
	/**
	 * 单减社保，存在正常/审批中的公积金，禁止“同步终止合同、减项、减档”
	 */
	String EMP_DISPATCH_FUND_NOT_EMPTY_CHANGE = "emp.dispatch.fund.not.empty.change";
	/**
	 * 派减异常： 单减公积金，是否同步终止合同、减项、减档不能为是
	 */
	String EMP_DISPATCH_FUND_NOT_EMPTY_SIGNLE = "emp.dispatch.fund.not.empty.signle";
	/**
	 * 公积金未派减，请核实！
	 */
	String EMP_DISPATCH_SIGNLE_REDUCE = "emp.dispatch.signle.reduce";
}
