package com.yifu.cloud.plus.v1.yifu.common.core.util.alisms;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import lombok.extern.slf4j.Slf4j;

/**
 * @program: master
 * @description: 阿里云短信工具
 * @author: pwang
 * @create: 2020-08-24 11:44
 **/
@Slf4j
public class SmsUtil {

    private static final String ACCESS_KEY_ID = "LTAI4G1h6voBYGPCV4RNmqMo";
    private static final String ACCESS_KEY_SECRET = "1e4TWryIdScpsIqPxXZynGNMASdCkl";
    private static final String ERROR_INFO = "调取阿里云服务异常";

    private SmsUtil() { throw new IllegalStateException("Utility class");}
    /**
     * 短信发送方法
     * @Author fxj
     * @Date 2022-12-12
     * @param phone
     * @param code
     * @param signName
     * @return 正确结果{"Message":"OK","RequestId":"38FA1BE1-52C1-4833-9211-AD55CF264988","BizId":"342207398251524244^0","Code":"OK"}
     **/
    public static AliSmsResult sendSms(String phone,String code,String signName) {
        DefaultProfile profile = DefaultProfile.getProfile("cn-hangzhou", ACCESS_KEY_ID, ACCESS_KEY_SECRET);
        IAcsClient client = new DefaultAcsClient(profile);

        JSONObject exceptionResult = new JSONObject();
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain("dysmsapi.aliyuncs.com");
        request.setSysVersion("2017-05-25");
        request.setSysAction("SendSms");
        request.putQueryParameter("RegionId", "cn-hangzhou");
        request.putQueryParameter("PhoneNumbers", phone);
        request.putQueryParameter("SignName", signName);
        request.putQueryParameter("TemplateCode", "SMS_200465275");
        request.putQueryParameter("TemplateParam", "{\"code\":\""+code+"\"}");
        try {
            CommonResponse response = client.getCommonResponse(request);
            return JSON.parseObject(response.getData(),AliSmsResult.class);
        } catch (Exception e) {
            log.error(ERROR_INFO,e);
            exceptionResult.put("Message", ERROR_INFO);
            exceptionResult.put("Code", "ERROR");
            return exceptionResult.toJavaObject(AliSmsResult.class);
        }
    }
    /**
     * 发送皖信人力云的短信方法
     * @Author fxj
     * @Date 2022-12-12
     * @param phone
     * @param code
     * @return 错误示例 {"Message":"模板不合法(不存在或被拉黑)","RequestId":"D7923A5B-AE30-481C-84D4-56BB0F230848","Code":"isv.SMS_TEMPLATE_ILLEGAL"}
     **/
    public static AliSmsResult sendSms(String phone,String code) {
        return sendSms(phone,code,"皖信人力云");
    }

}
