package com.yifu.cloud.plus.v1.yifu.ekp.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

/**
 * @author licancan
 * @description 对接ekp订单
 * @date 2022-08-31 15:35:20
 */
@Data
@Component
@PropertySource("classpath:ekpOrderConfig.properties")
@ConfigurationProperties(value = "ekporder",ignoreInvalidFields = false)
public class EkpOrderProperties {

	/**
	 * 接口url
	 */
	String url;

	/**
	 * 订单modelId
	 */
	String orderFdModelId;

	/**
	 * 订单flowID
	 */
	String orderFdFlowId;

	/**
	 * 订单回复modelId
	 */
	String replyFdModelId;

	/**
	 * 订单回复flowID
	 */
	String replyFdFlowId;

	/**
	 * 订单附件key
	 */
	String replyAttachKey;

	String docStatus;

	String LoginName;

	/**
	 * 描述：用于项目订单更新接口
	 */
	String orderDocSubject;

	/**
	 * 描述：用于订单回复接口
	 */
	String replyDocSubject;
}
