package com.yifu.cloud.plus.v1.yifu.ekp.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.ekp.config.EkpInsuranceProperties;
import com.yifu.cloud.plus.v1.yifu.ekp.constant.EkpConstants;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EKPInsurancePushParam;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.EkpInteractiveParam;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.EkpUpdateParam;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.TInsuranceSettlePushParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;


/**
 * @author zhaji
 * @description EKP交互工具类
 *
 * @date 2022-08-05 09:42:33
 */
@Slf4j
@EnableConfigurationProperties(EkpInsuranceProperties.class)
public class EkpInsuranceUtil {

	@Resource
	private EkpInsuranceProperties ekpInsuranceProperties;

	/**
	 * 多层级的VO对象，且包含上传功能的样例
	 * 注意key的书写格式,类似EL表达式的方式，属性关系用'.', 列表和数组关系用[]，Map关系用["xxx"]
	 */
	public String sendToEkp(EkpInteractiveParam param){
		RestTemplate yourRestTemplate = new RestTemplate();
		EKPInsurancePushParam pushParam = insuranceDetail2PushParam(param);
		try{
			String formValues = new ObjectMapper().writeValueAsString(pushParam);
			//指向EKP的接口url
			//把ModelingAppModelParameterAddForm转换成MultiValueMap
			MultiValueMap<String,Object> wholeForm = new LinkedMultiValueMap<>();
			wholeForm.add("docSubject",ekpInsuranceProperties.getInsuranceDocSubject());
			wholeForm.add("docCreator", "{\"LoginName\":\"admin\"}");
			wholeForm.add("docStatus", ekpInsuranceProperties.getInsuranceDocStatus());
			wholeForm.add("fdModelId", ekpInsuranceProperties.getInsuranceFdModelId());
			wholeForm.add("fdFlowId", ekpInsuranceProperties.getInsuranceFdFlowId());
			wholeForm.add("formValues", formValues);
			HttpHeaders headers = new HttpHeaders();
			//如果EKP对该接口启用了Basic认证，那么客户端需要加入
			//addAuth(headers,"yourAccount"+":"+"yourPassword");是VO，则使用APPLICATION_JSON
			headers.setContentType(MediaType.MULTIPART_FORM_DATA);
			//必须设置上传类型，如果入参是字符串，使用MediaType.TEXT_PLAIN；如果
			HttpEntity<MultiValueMap<String,Object>> entity = new HttpEntity<MultiValueMap<String,Object>>(wholeForm,headers);
			//有返回值的情况 VO可以替换成具体的JavaBean
			log.info("推送EKP开始,formValues:"+formValues);
			ResponseEntity<String> obj = yourRestTemplate.exchange(ekpInsuranceProperties.getInsuranceUrl(), HttpMethod.POST, entity, String.class);
			String body = obj.getBody();
			if (StringUtils.isBlank(body)){
				log.error("交易失败:"+obj);
				return null;
			}else{
				log.info("交易成功："+obj);
				return body;
			}
		}catch (Exception e){
			log.error("交易失败:", e);
			return null;
		}
	}

	/**
	 * 商险修改信息推送ekp
	 *
	 * @author licancan
	 * @param param
	 * @return {@link String}
	 */
	public String sendUpdateToEkp(EkpUpdateParam param){
		log.info("推送EKP开始--商险修改");
		RestTemplate yourRestTemplate = new RestTemplate();
		try{
			String formValues = new ObjectMapper().writeValueAsString(param);
			//指向EKP的接口url
			//把ModelingAppModelParameterAddForm转换成MultiValueMap
			MultiValueMap<String,Object> wholeForm = new LinkedMultiValueMap<>();
			wholeForm.add("docSubject",ekpInsuranceProperties.getInsuranceUpdateDocSubject());
			wholeForm.add("docCreator", "{\"LoginName\":\"admin\"}");
			wholeForm.add("docStatus", ekpInsuranceProperties.getInsuranceDocStatus());
			wholeForm.add("fdModelId", ekpInsuranceProperties.getInsuranceUpdateFdModelId());
			wholeForm.add("fdFlowId", ekpInsuranceProperties.getInsuranceUpdateFdFlowId());
			wholeForm.add("formValues", formValues);
			log.info("wholeForm:" + wholeForm);
			HttpHeaders headers = new HttpHeaders();
			//如果EKP对该接口启用了Basic认证，那么客户端需要加入
			//addAuth(headers,"yourAccount"+":"+"yourPassword");是VO，则使用APPLICATION_JSON
			headers.setContentType(MediaType.MULTIPART_FORM_DATA);
			//必须设置上传类型，如果入参是字符串，使用MediaType.TEXT_PLAIN；如果
			HttpEntity<MultiValueMap<String,Object>> entity = new HttpEntity<MultiValueMap<String,Object>>(wholeForm,headers);
			//有返回值的情况 VO可以替换成具体的JavaBean
			ResponseEntity<String> obj = yourRestTemplate.exchange(ekpInsuranceProperties.getInsuranceUrl(), HttpMethod.POST, entity, String.class);
			String body = obj.getBody();
			if (StringUtils.isBlank(body)){
				log.error(EkpConstants.SEND_FAILED);
				return null;
			}else{
				log.info(EkpConstants.SEND_SUCCESS + body);
				return body;
			}
		}catch (Exception e){
			log.error(EkpConstants.SEND_FAILED +":", e);
			return null;
		}
	}

	/**
	 * 将类转换成EKP要求的格式
	 *
	 * @author zhaji
	 * @param param 转换类
	 * @return {@link TInsuranceSettlePushParam}
	 */
	public static EKPInsurancePushParam insuranceDetail2PushParam(EkpInteractiveParam param){
			String format = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
			EKPInsurancePushParam pushParam = new EKPInsurancePushParam();
			param.setHappenDate(format);
			//ekpId
			if(null != param.getDetailId() && null != param.getDefaultSettleId()){
				pushParam.setFd_3afa8a70006bea(param.getDetailId()+CommonConstants.DOWN_LINE_STRING+param.getDefaultSettleId());
			}else{
				pushParam.setFd_3afa8a70006bea(CommonConstants.EMPTY_STRING);
			}
			//单据类型
			if(null != param.getSettleType()){
				pushParam.setFd_3adfe6af71a1cc(param.getSettleType());
			}else{
				pushParam.setFd_3adfe6af71a1cc(CommonConstants.EMPTY_STRING);
			}
			//项目编码
			pushParam.setFd_3adfe658c6229e(param.getDeptNo());
			if(null != param.getDeptNo()){
				pushParam.setFd_3adfe658c6229e(param.getDeptNo());
			}else{
				pushParam.setFd_3adfe658c6229e(CommonConstants.EMPTY_STRING);
			}
			//项目名称
			pushParam.setFd_3adfe6592b4158(param.getDeptName());
			if(null != param.getDeptName()){
				pushParam.setFd_3adfe6592b4158(param.getDeptName());
			}else{
				pushParam.setFd_3adfe6592b4158(CommonConstants.EMPTY_STRING);
			}
			//客户编码
			pushParam.setFd_3adfe6598281e8(param.getCustomerCode());
			if(null != param.getCustomerCode()){
				pushParam.setFd_3adfe6598281e8(param.getCustomerCode());
			}else{
				pushParam.setFd_3adfe6598281e8(CommonConstants.EMPTY_STRING);
			}
			//客户名称
			pushParam.setFd_3adfe7a2688902(param.getCustomerName());
			if(null != param.getCustomerName()){
				pushParam.setFd_3adfe7a2688902(param.getCustomerName());
			}else{
				pushParam.setFd_3adfe7a2688902(CommonConstants.EMPTY_STRING);
			}
			//发生日期
			pushParam.setFd_3adfe67c24dace(param.getHappenDate());
			//姓名
			pushParam.setFd_3adfe65d759650(param.getEmpName());
			if(null != param.getEmpName()){
				pushParam.setFd_3adfe65d759650(param.getEmpName());
			}else{
				pushParam.setFd_3adfe65d759650(CommonConstants.EMPTY_STRING);
			}
			//身份证号
			pushParam.setFd_3adfe65dbd9f68(param.getEmpIdcardNo());
			if(null != param.getEmpIdcardNo()){
				pushParam.setFd_3adfe65dbd9f68(param.getEmpIdcardNo());
			}else{
				pushParam.setFd_3adfe65dbd9f68(CommonConstants.EMPTY_STRING);
			}
			//发票号
			if(null != param.getInvoiceNo()){
				pushParam.setFd_3adfe65e0cd094(param.getInvoiceNo());
			}else{
				pushParam.setFd_3adfe65e0cd094(CommonConstants.EMPTY_STRING);
			}
			//险种
			if(null != param.getInsuranceTypeName()){
				pushParam.setFd_3adfe65f6599e4(param.getInsuranceTypeName());
			}else{
				pushParam.setFd_3adfe65f6599e4(CommonConstants.EMPTY_STRING);
			}
			//保险公司
			if(null != param.getInsuranceCompanyName()){
				pushParam.setFd_3adfe65ea04728(param.getInsuranceCompanyName());
			}else{
				pushParam.setFd_3adfe65ea04728(CommonConstants.EMPTY_STRING);
			}
			//保单号
			if(null != param.getPolicyNo()){
				pushParam.setFd_3adfe65e60e110(param.getPolicyNo());
			}else{
				pushParam.setFd_3adfe65e60e110(CommonConstants.EMPTY_STRING);
			}
			//保险开始日期
			if(null != param.getPolicyStart()){
				pushParam.setFd_3adfe6b7e0ede8(param.getPolicyStart().toString());
			}else{
				pushParam.setFd_3adfe6b7e0ede8(CommonConstants.EMPTY_STRING);
			}
			//保险结束日期
			if(null != param.getPolicyEnd()){
				pushParam.setFd_3adfe6b847bfe6(param.getPolicyEnd().toString());
			}else{
				pushParam.setFd_3adfe6b847bfe6(CommonConstants.EMPTY_STRING);
			}
			//购买标准
			pushParam.setFd_3adfe6d55384c6(param.getBuyStandard());
			if(null != param.getBuyStandard()){
				pushParam.setFd_3adfe6d55384c6(param.getBuyStandard());
			}else{
				pushParam.setFd_3adfe6d55384c6(CommonConstants.EMPTY_STRING);
			}
			//实际保费
			if(null != param.getActualPremium()){
				pushParam.setFd_3adfe6610c0d2c(param.getActualPremium().toString());
			}else{
				pushParam.setFd_3adfe6610c0d2c(CommonConstants.EMPTY_STRING);
			}
			//医保
			if(null != param.getMedicalQuota()){
				pushParam.setFd_3adfe66041a996(param.getMedicalQuota());
			}else{
				pushParam.setFd_3adfe66041a996(CommonConstants.EMPTY_STRING);
			}
			//事故或残疾
			if(null != param.getDieDisableQuota()){
				pushParam.setFd_3adfe6609aa810(param.getDieDisableQuota());
			}else{
				pushParam.setFd_3adfe6609aa810(CommonConstants.EMPTY_STRING);
			}
			//预估保费
			if(null != param.getEstimatePremium()){
				pushParam.setFd_3adfe6e30f2a3c(param.getEstimatePremium().toString());
			}else{
				pushParam.setFd_3adfe6e30f2a3c(CommonConstants.EMPTY_STRING);
			}
			//结算月
			if(null != param.getSettleMonth()){
				pushParam.setFd_3aea2f0180eccc(dateStringInsert(param.getSettleMonth()));
			}else{
				pushParam.setFd_3aea2f0180eccc(CommonConstants.EMPTY_STRING);
			}

			//交易类型
			if(null != param.getInteractiveType()){
				pushParam.setFd_3af9197b31071c(param.getInteractiveType());
			}else{
				pushParam.setFd_3af9197b31071c(CommonConstants.EMPTY_STRING);
			}

			//有无预估
			if(null != param.getEstimateStatus()){
				pushParam.setFd_3b0a5937928c8c(param.getEstimateStatus());
			}else{
				pushParam.setFd_3b0a5937928c8c(CommonConstants.EMPTY_STRING);
			}
			//是否bro客户
			if(null != param.getBpoFlag()){
				pushParam.setFd_3b178f8ba1a91c(param.getBpoFlag());
			}else{
				pushParam.setFd_3b178f8ba1a91c(CommonConstants.EMPTY_STRING);
			}
			//派单客服姓名
			if(null != param.getCreateName()){
				pushParam.setFd_3c6f0118af2ba6(param.getCreateName());
			}else{
				pushParam.setFd_3c6f0118af2ba6(CommonConstants.EMPTY_STRING);
			}
		return pushParam;
	}

	public static String dateStringInsert(String month) {
		if (month.length() == 6) {
			StringBuilder sb = new StringBuilder(month);
			sb.insert(4, "-");
			return sb.toString();
		}
		return month;
	}
}

