package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author fxj
 * @Date 2023/2/22
 * @Description
 * @Version 1.0
 */
@ColumnWidth(10)
@Data
public class InsuranceWarnExportVo implements Serializable {
	/**
	 * 员工姓名
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工姓名")
	@Schema(name = "员工姓名")
	private String empName;
	/**
	 * 员工身份证号
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工身份证号码")
	@Schema(name = "员工身份证号码")
	private String empIdcardNo;
	/**
	 * 客户名称
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "客户")
	@Schema(name = "客户")
	private String customerName;
	/**
	 * 结算部门名称中文（内部组织架构）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "项目名称")
	@Schema(name = "项目名称")
	private String deptName;
	/**
	 * 结算部门编码（内部组织架构）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "项目编码")
	@Schema(name = "项目编码")
	private String deptNo;
	/**
	 * 保险公司（配置项）
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "保险公司")
	@Schema(name = "保险公司（配置项）")
	private String insuranceCompanyName;
	/**
	 * 险种名称中文（配置项） 用于导入
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "险种名称")
	@Schema(name = "险种名称")
	private String insuranceTypeName;
	/**
	 * 保单开始时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "保单开始时间")
	@Schema(name = "保单开始时间")
	private String policyStart;
	/**
	 * 保单结束时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "保单结束时间")
	@Schema(name = "保单结束时间")
	private String policyEnd;

	/**
	 * 购买标准
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "购买标准")
	@Schema(name = "购买标准")
	private String buyStandard;

	/**
	 * 实际保费
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "实际保费")
	@Schema(name = "实际保费")
	private BigDecimal actualPremium;
	/**
	 * 创建人
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "创建人")
	@Schema(name = "创建人")
	private String createName;

	/**
	 * 创建时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "创建时间")
	@Schema(name = "创建时间")
	private String createTime;
	/**
	 * 投保办理状态 1待投保 2投保中 3已投保 4投保退回 5 已减员
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "状态")
	@Schema(name = "状态")
	private String buyHandleStatus;
	/**
	 * 出险状态（0未出险；1已出险）
	 */
	/*@Schema(name = "出险状态（0未出险；1已出险）")
	private Integer useStatus;*/
	/**
	 * 保单号
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "保单号")
	@Schema(name = "保单号")
	private String policyNo;
	/**
	 * 医保
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "医保")
	@Schema(name = "医保")
	private BigDecimal medicalQuota;

	/**
	 * 身故或残疾
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "身故或残疾")
	@Schema(name = "身故或残疾")
	private BigDecimal dieDisableQuota;

	/**
	 * 结算月份
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "结算月份")
	@Schema(name = "结算月份")
	private String settleMonth;
	/**
	 * 发票号
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "发票号")
	@Schema(name = "发票号")
	private String invoiceNo;

	/**
	 * 被替换时间
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "被替换时间")
	@Schema(name = "被替换时间")
	private String replaceTime;

	/**
	 * 保单生效时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "保单生效时间")
	@Schema(name = "保单生效时间")
	private String policyEffect;

	/**
	 * 备注
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "备注")
	@Schema(name = "备注")
	private String remark;


/*	*//**
	 * 商险购买地省
	 *//*
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "商险购买地省")
	@Schema(name = "商险购买地省")
	private String insuranceProvince;*/
	/**
	 * 商险购买地
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "商险购买地市")
	@Schema(name = "商险购买地市")
	private String insuranceCityName;
	/**
	 * 商险购买地
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "商险办理地市")
	@Schema(name = "商险办理地市")
	private String insuranceHandleCityName;
	/**
	 * 是否有效 0有效 1无效
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "是否有效")
	@Schema(name = "是否有效 0有效 1无效")
	private String isEffect;
	/**
	 * 岗位
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "岗位")
	@Schema(name = "岗位")
	private String post;

	//替换人名称,用户展示
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "被替换人姓名")
	@Schema(name = "被替换人姓名")
	private String fromEmpName;

	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "替换人姓名")
	@Schema(name = "替换人姓名")
	//被替换名称,用户展示
	private String toEmpName;

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "替换时间")
	@Schema(name = "替换时间")
	private String toReplaceTime;

	/**
	 * 是否过期状态 0 未过期 1已过期。主要用于页面查询展示
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "是否过期")
	@Schema(name = "是否过期")
	private String isOverdue;

	/**
	 * 预估保费
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "预估保费")
	@Schema(name = "预估保费")
	private BigDecimal estimatePremium;

	/**
	 * 结算类型 (0、与薪资结算 1、单独结算)
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "结算类型")
	@Schema(description = "结算类型 (0、与薪资结算 1、单独结算)")
	private String settleType;

	/**
	 * 退费金额
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "退费金额")
	@Schema(name = "退费金额")
	private BigDecimal refundMoney;


	/**
	 * 退费时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "退费时间")
	@Schema(name = "退费时间")
	private String refundCreateTime;

	/**
	 * 退费人
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "退费人")
	@Schema(name = "退费人")
	private String refundCreateUser;

	/**
	 * 派单人所属部门
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "派单人所属部门")
	@Schema(name = "派单人所属部门")
	private String createUserDeptName;

	/**
	 * 消息提醒备注
	 */
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "消息提醒备注")
	private String expireRemark;

}
