package com.yifu.cloud.plus.v1.yifu.insurances.mapper.insurances;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsurancePolicy;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.InsurancePolicyListParam;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author licancan
 * @description 针对表【t_insurance_policy(保单号对应起止时间表)】的数据库操作Mapper
 * @date 2022-12-07 16:40:16
 */
@Mapper
public interface TInsurancePolicyMapper extends BaseMapper<TInsurancePolicy> {

	/**
	 * 保单号对应起止保时间分页查询
	 *
	 * @param page            分页对象
	 * @param param 查询参数
	 * @return {@link IPage <TInsurancePolicy>}
	 * @author licancan
	 */
	IPage<TInsurancePolicy> getInsurancePolicyListPage(Page page,@Param("param") InsurancePolicyListParam param);

	/**
	 * 保单号对应起止保时间列表（不分页）
	 *
	 * @author licancan
	 * @param param
	 * @return {@link List< TInsurancePolicy>}
	 */
	List<TInsurancePolicy> getInsurancePolicyList(@Param("param") InsurancePolicyListParam param);
}




