package com.yifu.cloud.plus.v1.job.compont;


import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprEkpPermissionProperties;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.HttpDaprUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @Author hgw
 * @Description EKP权限定时任务
 * @Date 2023-9-5 09:40:09
 **/
@Component(value = "ekpPermissionTask")
@Slf4j
@EnableConfigurationProperties(DaprEkpPermissionProperties.class)
public class EkpPermissionTask {

	@Autowired
	private DaprEkpPermissionProperties daprEkpPermissionProperties;

	/**
	 * @return
	 * @Author hgw
	 * @Description 刷新EKP权限里的账号信息
	 * @Date 2023-9-5 09:45:22
	 * @Param
	 **/
	public void doRefreshEkpUser() throws Exception {
		log.info("-------------刷新EKP权限里的账号信息-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprEkpPermissionProperties.getAppUrl(), daprEkpPermissionProperties.getAppId(),
				"/sysuserinfo/inner/doRefreshEkpUser", "", Object.class,
				SecurityConstants.FROM_IN);
		log.info("-------------刷新EKP权限里的账号信息-定时任务结束------------");
	}

}