package com.yifu.cloud.plus.v1.job.compont;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprSocialProperties;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.HttpDaprUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * @Author hgw
 * @Date 2022-7-27 19:37:14
 * @Description 社保定时任务
 * @Version 1.0
 */
@Component(value = "socialTask")
@Slf4j
@EnableConfigurationProperties(DaprSocialProperties.class)
public class SocialTask {

	@Autowired
	private DaprSocialProperties daprProperties;

	/**
	 * @Description: 定时生成基数配置新增的数据
	 * @Author: hgw
	 * @Date: 2022/7/27 19:39
	 * @return: void
	 **/
	public void updateForecastLibaryBySysBase() {
		log.info("------------定时生成基数配置新增的数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tforecastlibrary/inner/updateForecastLibaryBySysBase","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成基数配置新增的数据-定时任务结束------------");
	}

	/**
	 * @Description: 每月定时生成下月预估库数据
	 *
	 * 必须在【定时生成基数配置新增的数据】之后执行
	 *
	 * @Author: hgw
	 * @Date: 2022/7/27 19:39
	 * @return: void
	 **/
	public void everyMonthCreateForecastLibary() {
		log.info("------------每月定时生成下月预估库数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tforecastlibrary/inner/everyMonthCreateForecastLibary","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------每月定时生成下月预估库数据-定时任务结束------------");
	}

	/**
	 * @Description: 定时生成社保预估明细的数据
	 * @Author: huyc
	 * @Date: 2022/8/30
	 * @return: void
	 **/
	public void createForecastInfo() {
		log.info("------------定时生成社保预估明细的数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tforecastlibrary/inner/createForecastInfo","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成社保预估明细的数据-定时任务结束------------");
	}

	/**
	 * @Description: 定时生成公积金预估明细的数据
	 * @Author: huyc
	 * @Date: 2022/8/30
	 * @return: void
	 **/
	public void createForecastFundInfo() {
		log.info("------------定时生成公积金预估明细的数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tforecastlibrary/inner/createForecastFundInfo","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成公积金预估明细的数据-定时任务结束------------");
	}

	/**
	 * @Description: 定时生成社保缴费库明细的数据
	 * @Author: huyc
	 * @Date: 2022/8/30
	 * @return: void
	 **/
	public void createPaymentSocialInfo() {
		log.info("------------定时生成社保缴费库明细的数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tpaymentinfo/inner/createPaymentSocialInfo","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成社保缴费库明细的数据-定时任务结束------------");
	}

	/**
	 * @Description: 定时生成公积金缴费库明细的数据
	 * @Author: huyc
	 * @Date: 2022/8/30
	 * @return: void
	 **/
	public void createPaymentFundInfo() {
		log.info("------------定时生成公积金缴费库明细的数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tpaymentinfo/inner/createPaymentFundInfo","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成公积金缴费库明细的数据-定时任务结束------------");
	}

	/**
	 * @Description: 定时生成社保缴费库收入的数据
	 * @Author: huyc
	 * @Date: 2022/8/30
	 * @return: void
	 **/
	public void createPaymentInfoIncome() {
		log.info("------------定时生成缴费库社保的收入数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tpaymentinfo/inner/createPaymentInfoIncome","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成缴费库社保的收入数据-定时任务结束------------");
	}

	/**
	 * @Description: 定时生成公积金缴费库明细的数据
	 * @Author: huyc
	 * @Date: 2022/8/30
	 * @return: void
	 **/
	public void createPaymentFundIncome() {
		log.info("------------定时生成缴费库公积金的收入数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tpaymentinfo/inner/createPaymentFundIncome","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时生成缴费库公积金的收入数据-定时任务结束------------");
	}

	/**
	 * @Description: 定时任务生成统计表数据
	 * @Author: huyc
	 * @Date: 2022/8/30
	 * @return: void
	 **/
	public void pushDetail() {
		log.info("------------定时任务生成统计表数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tincome/inner/pushDetail","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时任务生成统计表数据-定时任务结束------------");
	}


	/**
	 * @Description: 定时任务标识根据项目不需要生成收入的数据
	 * @Author: huyc
	 * @Date: 2022/8/30
	 * @return: void
	 **/
	public void signPaymentNoIncomeFlag() {
		log.info("------------定时任务标识根据项目不需要生成收入的数据-定时任务开始------------");
		HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tpaymentinfo/inner/signPaymentNoIncomeFlag","", Object.class, SecurityConstants.FROM_IN);
		log.info("------------定时任务标识根据项目不需要生成收入的数据-定时任务结束------------");
	}
}
