package com.yifu.cloud.plus.v1.yifu.order.controller;

import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.order.constants.OrderConstants;
import com.yifu.cloud.plus.v1.yifu.order.service.TOrderService;
import com.yifu.cloud.plus.v1.yifu.order.util.EkpOrderFileTask;
import com.yifu.cloud.plus.v1.yifu.order.vo.OrderAddVO;
import com.yifu.cloud.plus.v1.yifu.order.vo.OrderAttVo;
import com.yifu.cloud.plus.v1.yifu.order.vo.OrderReplyAddVO;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

import javax.annotation.Resource;
import java.io.File;
import java.io.IOException;

/**
 * @author licancan
 * @description 接收ekp订单controller
 * @date 2022-08-31 08:54:06
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/ekp/order")
@Tag(name = "接收ekp订单相关")
@Slf4j
public class EkpOrderController {
	@Resource
	private TOrderService tOrderService;
	@Autowired
	private EkpOrderFileTask ekpOrderFileTask;
	/**
	 * 接收处理ekp订单
	 *
	 * @author licancan
	 * @param vo
	 * @return {@link R}
	 * @throws IOException
	 */
	@Schema(description = "接收处理ekp订单")
	@PostMapping(value = "/receiveOrder")
	public R receiveOrder(OrderAddVO vo) throws IOException {
		return tOrderService.receiveOrder(vo,ekpOrderFileTask);
	}


	/**
	 * 接收处理ekp
	 *
	 * @author licancan
	 * @param vo
	 * @return {@link R}
	 * @throws IOException
	 */
	@Schema(description = "接收处理ekp附件")
	@PostMapping(value = "/receiveOrderNew")
	public R receiveOrder(OrderAttVo vo) throws IOException {
		if (Common.isEmpty(vo.getOrderNo())){
			return R.failed(OrderConstants.ORDER_NO_IS_EMPTY);
		}
		if (ArrayUtils.isNotEmpty(vo.getFile())){
			if (vo.getFile().length > CommonConstants.TWENTY_INT){
				return R.failed(OrderConstants.ENCLOSURE_SIZE_ERROR);
			}
			String fileName;
			for (MultipartFile multipartFile : vo.getFile()) {
				if(!Common.checkInsuranceFile(multipartFile.getOriginalFilename())){
					return R.failed(OrderConstants.ENCLOSURE_TYPE_IS_ERROR);
				}
				if (multipartFile.getSize() > (CommonConstants.FIFTY_INT*CommonConstants.BYTE*CommonConstants.BYTE)){
					return R.failed(OrderConstants.ENCLOSURE_SIZE_ERROR);
				}
				fileName = System.currentTimeMillis() + "_" + multipartFile.getOriginalFilename();
				ekpOrderFileTask.receiveOrderNew(multipartFile.getInputStream(),vo.getFile1(),vo.getOrderNo(),fileName
						,multipartFile.getOriginalFilename());
			}
		}
		return R.ok();
	}

	/**
	 * 接收处理ekp订单回复
	 *
	 * @author licancan
	 * @param vo
	 * @return {@link R}
	 * @throws IOException
	 */
	@Schema(description = "接收处理ekp订单回复")
	@PostMapping(value = "/receiveOrderReply")
	public R receiveOrderReply(OrderReplyAddVO vo) throws IOException {
		return tOrderService.receiveOrderReply(vo);
	}

}
