package com.yifu.cloud.plus.v1.yifu.permission.entity;/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 新权限-角色表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
@Data
@TableName("sys_role_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "新权限-角色表")
public class SysRoleInfo extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String fdId;
	/**
	 * 角色名称
	 */
	@ExcelAttribute(name = "角色名称", isNotEmpty = true, errorInfo = "角色名称不能为空", maxLength = 20)
	@NotBlank(message = "角色名称不能为空")
	@Length(max = 20, message = "角色名称不能超过20个字符")
	@ExcelProperty("角色名称")
	@Schema(description = "角色名称")
	private String roleName;
	/**
	 * 角色描述
	 */
	@ExcelAttribute(name = "角色描述", maxLength = 200)
	@Length(max = 200, message = "角色描述不能超过200个字符")
	@ExcelProperty("角色描述")
	@Schema(description = "角色描述")
	private String remark;
	/**
	 * 状态：0：正常；1：冻结/停用
	 */
	@ExcelAttribute(name = "状态：0：正常；1：冻结/停用", isNotEmpty = true, errorInfo = "状态：0：正常；1：冻结/停用不能为空")
	@NotBlank(message = "状态：0：正常；1：冻结/停用不能为空")
	@ExcelProperty("状态：0：正常；1：冻结/停用")
	@Schema(description = "状态：0：正常；1：冻结/停用")
	private Integer status;
	/**
	 * 删除状态图：0：正常；1：删除
	 */
	@ExcelAttribute(name = "删除状态图：0：正常；1：删除", isNotEmpty = true, errorInfo = "删除状态图：0：正常；1：删除不能为空")
	@NotBlank(message = "删除状态图：0：正常；1：删除不能为空")
	@ExcelProperty("删除状态图：0：正常；1：删除")
	@Schema(description = "删除状态图：0：正常；1：删除")
	private Integer deleteFlag;
	/**
	 * 数据权限（全量0；部分全量1；数据权限2；客户a；商机b；报价单c；合同d；项目e；BUf；条线g；收入归属h；）
	 */
	@ExcelAttribute(name = "数据权限（全量0；部分全量1；数据权限2；客户a；商机b；报价单c；合同d；项目e；BUf；条线g；收入归属h；）", isNotEmpty = true, errorInfo = "数据权限（全量0；部分全量1；数据权限2；客户a；商机b；报价单c；合同d；项目e；BUf；条线g；收入归属h；）不能为空", maxLength = 50)
	@NotBlank(message = "数据权限（全量0；部分全量1；数据权限2；客户a；商机b；报价单c；合同d；项目e；BUf；条线g；收入归属h；）不能为空")
	@Length(max = 50, message = "数据权限（全量0；部分全量1；数据权限2；客户a；商机b；报价单c；合同d；项目e；BUf；条线g；收入归属h；）不能超过50个字符")
	@ExcelProperty("数据权限（全量0；部分全量1；数据权限2；客户a；商机b；报价单c；合同d；项目e；BUf；条线g；收入归属h；）")
	@Schema(description = "数据权限（全量0；部分全量1；数据权限2；客户a；商机b；报价单c；合同d；项目e；BUf；条线g；收入归属h；）")
	private String dataAuth;

}
