package com.yifu.cloud.plus.v1.yifu.permission.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 新权限-用户权限表
 *
 * @author hyc
 * @date 2023-08-29 14:49:40
 */
@Data
@TableName("sys_user_permission")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "新权限-用户权限表")
public class SysUserPermission extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "id")
	private String id;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 登录账号
	 */
	@Schema(description = "登录账号")
	private String empLoginName;

	/**
	 * 用户id
	 */
	@Schema(description = "用户id")
	private String userId;

	/**
	 * 所在部门
	 */
	@Schema(description = "所在部门")
	private String empDept;

	/**
	 * 权限类型 客户、商机、报价单、
	 * 1客户权限；2商机；3报价单；4合同；5项目；6BU；7条线；8部门；9收入归属
	 */
	@Schema(description = "权限类型")
	private String permissionType;

	/**
	 * 名称
	 */
	@Schema(description = "名称")
	private String name;

	/**
	 * 编码
	 */
	@Schema(description = "编码")
	private String code;

	/**
	 * 是否包含(0 是 1否)
	 */
	@Schema(description = "是否包含(0 是 1否)")
	private String isContains;

	/**
	 * 授权状态（0启用、1禁用）
	 */
	@Schema(description = "授权状态（0启用、1禁用）")
	private String permissionStatus;

	/**
	 * 删除状态（0是、1否）
	 */
	@Schema(description = "删除状态（0是、1否）")
	private String deleteFlag;

	/**
	 * 部门id
	 */
	@Schema(description = "部门id")
	private String domainId;

	/**
	 * 0：从EKP同步的；1：MVP新增的。
	 */
	@Schema(description = "来源")
	private String sourceType;
}
