package com.yifu.cloud.plus.v1.yifu.permission.vo;/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 新权限-账号-角色关联表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
@Data
public class SysUserRoleResVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@Length(max = 36, message = "主键 不能超过36 个字符")
	@ExcelAttribute(name = "主键", isNotEmpty = true, errorInfo = "主键 不能为空", maxLength = 36)
	@Schema(description = "主键")
	@ExcelProperty("主键")
	private String fdId;
	/**
	 * 账号ID
	 */
	@NotBlank(message = "账号ID 不能为空")
	@Length(max = 36, message = "账号ID 不能超过36 个字符")
	@ExcelAttribute(name = "账号ID", isNotEmpty = true, errorInfo = "账号ID 不能为空", maxLength = 36)
	@Schema(description = "账号ID")
	@ExcelProperty("账号ID")
	private String userId;
	/**
	 * 角色ID
	 */
	@NotBlank(message = "角色ID 不能为空")
	@Length(max = 36, message = "角色ID 不能超过36 个字符")
	@ExcelAttribute(name = "角色ID", isNotEmpty = true, errorInfo = "角色ID 不能为空", maxLength = 36)
	@Schema(description = "角色ID")
	@ExcelProperty("角色ID")
	private String roleId;

}
