package com.yifu.cloud.plus.v1.permission.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.permission.service.SysMenuService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysMenu;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysMenuSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;


/**
 * 新权限-菜单表
 *
 * @author hyc
 * @date 2023-08-29 14:49:40
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/sysmenu")
@Tag(name = "新权限-菜单表管理")
public class SysMenuController {

	private final SysMenuService sysMenuService;

	/**
	 * 简单分页查询
	 *
	 * @param page    分页对象
	 * @param sysMenu 新权限-菜单表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<SysMenu>> getSysMenuPage(Page<SysMenu> page, SysMenuSearchVo sysMenu) {
		return new R<>(sysMenuService.getSysMenuPage(page, sysMenu));
	}

	/**
	 * 新增新权限-菜单表
	 *
	 * @param sysMenu 新权限-菜单表
	 * @return R
	 */
	@Operation(description = "新增新权限-菜单表：hasPermission('permission_sysmenu_add')")
	@SysLog("新增新权限-菜单表")
	@PostMapping("/addMenu")
	@PreAuthorize("@pms.hasPermission('permission_sysmenu_add')")
	public R<Boolean> save(@RequestBody SysMenu sysMenu) {
		return sysMenuService.saveMenu(sysMenu);
	}

	/**
	 * 修改新权限-菜单表
	 *
	 * @param sysMenu 新权限-菜单表
	 * @return R
	 */
	@Operation(description = "修改新权限-菜单表：hasPermission('permission_sysmenu_edit')")
	@SysLog("修改新权限-菜单表")
	@PostMapping("/updateMenu")
	@PreAuthorize("@pms.hasPermission('permission_sysmenu_edit')")
	public R<Boolean> updateById(@RequestBody SysMenu sysMenu) {
		return sysMenuService.updateMenu(sysMenu);
	}

	/**
	 * 修改新权限-菜单表
	 *
	 * @param sysMenu 新权限-菜单表
	 * @return R
	 */
	@Operation(description = "修改新权限-菜单表：hasPermission('permission_sysmenu_edit')")
	@SysLog("修改新权限-菜单表")
	@PostMapping("/updateMenuById")
	@PreAuthorize("@pms.hasPermission('permission_sysmenu_edit')")
	public R<Boolean> updateMenu(@RequestBody SysMenu sysMenu) {
		return new R<>(sysMenuService.updateById(sysMenu));
	}

	/**
	 * 通过id查询新权限-菜单表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询")
	@GetMapping("/{id}")
	public R<SysMenu> getById(@PathVariable("id") String id) {
		return R.ok(sysMenuService.getById(id));
	}
}
