package com.yifu.cloud.plus.v1.permission.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.permission.service.SysRoleInfoService;
import com.yifu.cloud.plus.v1.permission.service.SysUserRoleResService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysRoleInfo;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysRoleInfoSaveVo;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysRoleInfoSearchVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 新权限-角色表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/sysroleinfo")
@Tag(name = "新权限-角色表管理")
public class SysRoleInfoController {

	private final SysRoleInfoService sysRoleInfoService;
	private final SysUserRoleResService sysUserRoleResService;


	/**
	 * 简单分页查询
	 *
	 * @param page        分页对象
	 * @param sysRoleInfo 新权限-角色表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<SysRoleInfo>> getSysRoleInfoPage(Page<SysRoleInfo> page, SysRoleInfoSearchVo sysRoleInfo) {
		return new R<>(sysRoleInfoService.getSysRoleInfoPage(page, sysRoleInfo));
	}

	/**
	 * 不分页查询
	 *
	 * @param sysRoleInfo 新权限-角色表
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	//@PreAuthorize("@pms.hasPermission('ekp_sysroleinfo_get')" )
	public R<List<SysRoleInfo>> getSysRoleInfoNoPage(@RequestBody SysRoleInfoSearchVo sysRoleInfo) {
		return R.ok(sysRoleInfoService.noPageDiy(sysRoleInfo));
	}

	/**
	 * 通过id查询新权限-角色表
	 *
	 * @param fdId id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询")
	@GetMapping("/{fdId}")
	public R<SysRoleInfoSaveVo> getById(@PathVariable("fdId") String fdId) {
		return sysRoleInfoService.getInfoById(fdId);
	}

	/**
	 * @param roleIdList 角色列表
	 * @Description: 给前端使用：根据角色id组合获取角色权限
	 * @Author: hgw
	 * @Date: 2023/9/8 9:29
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.permission.vo.SysUserInfoSaveVo>
	 **/
	@Operation(summary = "给前端使用：根据角色id组合获取角色权限", description = "给前端使用：根据角色id组合获取角色权限")
	@PostMapping("/getRoleDataAuthByRoleId")
	public R<String> getRoleDataAuthByRoleId(@RequestBody List<String> roleIdList) {
		return R.ok(sysRoleInfoService.getRoleDataAuthByRoleId(roleIdList));
	}

	/**
	 * 新增新权限-角色表
	 *
	 * @param vo 新权限-角色表
	 * @return R
	 */
	@Operation(summary = "新增或编辑新权限-角色表", description = "新增或保存新权限-角色表：hasPermission('ekp_sysroleinfo_add')")
	@SysLog("新增或编辑新权限-角色表")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('ekp_sysroleinfo_add')")
	public R<String> saveOrUpdateRoleInfo(@RequestBody SysRoleInfoSaveVo vo) {
		return sysRoleInfoService.saveOrUpdateRoleInfo(vo);
	}

	/**
	 * 修改新权限-角色表
	 *
	 * @param sysRoleInfo 新权限-角色表
	 * @return R
	 */
	@Operation(summary = "修改新权限-角色表(可以修改状态)", description = "修改新权限-角色表：hasPermission('ekp_sysroleinfo_edit')")
	@SysLog("修改新权限-角色表")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('ekp_sysroleinfo_edit')")
	public R<Boolean> updateById(@RequestBody SysRoleInfo sysRoleInfo) {
		return R.ok(sysRoleInfoService.updateById(sysRoleInfo));
	}

	/**
	 * 通过id删除新权限-角色表
	 *
	 * @param fdId id
	 * @return R
	 */
	@Operation(summary = "通过id删除新权限-角色表-假删除", description = "通过id删除新权限-角色表：hasPermission('ekp_sysroleinfo_del')")
	@SysLog("通过id删除新权限-角色表")
	@DeleteMapping("/{fdId}")
	@PreAuthorize("@pms.hasPermission('ekp_sysroleinfo_del')")
	public R<Boolean> removeById(@PathVariable String fdId) {
		SysRoleInfo roleInfo = sysRoleInfoService.getById(fdId);
		if (roleInfo == null || Common.isEmpty(roleInfo.getFdId()) || Common.isEmpty(roleInfo.getRoleName())) {
			return R.failed("未找到角色");
		}
		// 删除关联表
		sysUserRoleResService.deleteByRoleId(fdId);
		// 假删除角色表
		roleInfo.setDeleteFlag(CommonConstants.ONE_INT);
		sysRoleInfoService.updateById(roleInfo);
		return R.ok();
	}

	/**
	 * 通过id删除新权限-角色表
	 *
	 * @param fdId id
	 * @return R
	 */
	@Operation(summary = "冻结-角色表", description = "冻结-角色表：hasPermission('ekp_sysroleinfo_freeze')")
	@SysLog("冻结-角色表")
	@PostMapping("/freezeById")
	@PreAuthorize("@pms.hasPermission('ekp_sysroleinfo_freeze')")
	public R<Boolean> freezeById(@RequestParam String fdId) {
		SysRoleInfo roleInfo = sysRoleInfoService.getById(fdId);
		if (roleInfo == null || Common.isEmpty(roleInfo.getFdId()) || Common.isEmpty(roleInfo.getRoleName())) {
			return R.failed("未找到角色");
		}
		// 删除关联表
		sysUserRoleResService.deleteByRoleId(fdId);
		// 冻结角色表
		roleInfo.setStatus(CommonConstants.ONE_INT);
		sysRoleInfoService.updateById(roleInfo);
		return R.ok();
	}

}
