package com.yifu.cloud.plus.v1.permission.mapper;/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysUserInfo;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysUserRoleRes;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 新权限-账号管理表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
@Mapper
public interface SysUserInfoMapper extends BaseMapper<SysUserInfo> {
	/**
	 * 新权限-账号管理表简单分页查询
	 *
	 * @param sysUserInfo 新权限-账号管理表
	 * @return
	 */
	IPage<SysUserInfo> getSysUserInfoPage(Page<SysUserInfo> page, @Param("sysUserInfo") SysUserInfo sysUserInfo);

	/**
	 * @param
	 * @Description: 获取EKP全部账号
	 * @Author: hgw
	 * @Date: 2023/9/4 11:32
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.permission.entity.SysUserInfo>
	 **/
	List<SysUserInfo> getEkpUser();


	List<SysUserRoleRes> getResAndRoleNameUserId(@Param("userId") String userId);


	/**
	 * @Description: 获取列表是否全量的权限
	 * @Author: hgw
	 * @Date: 2023/9/8 17:00
	 * @return: java.lang.int
	 **/
	int getAuthByUserIdAndModelId(@Param("modelId") String modelId, @Param("userId") String userId);

	/**
	 * @Description: 根据编码或者登录名简单分页查询
	 * @Author: huyc
	 * @Date: 2023/9/11 10:00
	 * @return:
	 **/
	IPage<SysUserInfo> getUserByCodeOrLoginName(Page<SysUserInfo> page, @Param("code") String code);
}
