package com.yifu.cloud.plus.v1.permission.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysMenu;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysMenuSearchVo;

/**
 * 新权限-菜单表
 *
 * @author hyc
 * @date 2023-08-29 14:49:40
 */
public interface SysMenuService extends IService<SysMenu> {

    /**
     * 新权限-菜单表简单分页查询
     * @param sysMenu 新权限-菜单表
     * @return
     */
    IPage<SysMenu> getSysMenuPage(Page<SysMenu> page, SysMenuSearchVo sysMenu);

	/**
	 * 新增菜单表
	 * @param menu 新权限-菜单表
	 * @return
	 */
	R<Boolean> saveMenu(SysMenu menu);

	/**
	 * 更新菜单表
	 * @param menu 新权限-菜单表
	 * @return
	 */
	R<Boolean> updateMenu(SysMenu menu);
}
