package com.yifu.cloud.plus.v1.permission.service;/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysRoleInfo;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysRoleInfoSaveVo;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysRoleInfoSearchVo;

import java.util.List;

/**
 * 新权限-角色表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
public interface SysRoleInfoService extends IService<SysRoleInfo> {
	/**
	 * 新权限-角色表简单分页查询
	 *
	 * @param sysRoleInfo 新权限-角色表
	 * @return
	 */
	IPage<SysRoleInfo> getSysRoleInfoPage(Page<SysRoleInfo> page, SysRoleInfoSearchVo sysRoleInfo);

	/**
	 * @param fdId
	 * @Description: 查看
	 * @Author: hgw
	 * @Date: 2023/8/30 15:10
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<com.yifu.cloud.plus.v1.yifu.permission.vo.SysRoleInfoSaveVo>
	 **/
	R<SysRoleInfoSaveVo> getInfoById(String fdId);

	/**
	 * @param vo
	 * @Description: 新增或编辑新权限-角色表
	 * @Author: hgw
	 * @Date: 2023/8/30 15:10
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.lang.Boolean>
	 **/
	R<String> saveOrUpdateRoleInfo(SysRoleInfoSaveVo vo);

	List<SysRoleInfo> noPageDiy(SysRoleInfoSearchVo searchVo);

	/**
	 * @param userId
	 * @Description: 各种角色的权限融合
	 * @Author: hgw
	 * @Date: 2023/8/30 18:06
	 * @return: java.lang.String
	 **/
	String getAllRoleDataAuthByUserId(String userId);

	/**
	 * @param roleIdList
	 * @Description: 给前端使用：根据角色id组合获取角色权限
	 * @Author: hgw
	 * @Date: 2023/9/8 9:25
	 * @return: java.lang.String
	 **/
	String getRoleDataAuthByRoleId(List<String> roleIdList);

}
