package com.yifu.cloud.plus.v1.permission.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysUserRoleRes;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysUserRoleResSearchVo;

import java.util.List;

/**
 * 新权限-账号-角色关联表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
public interface SysUserRoleResService extends IService<SysUserRoleRes> {
	/**
	 * 新权限-账号-角色关联表简单分页查询
	 *
	 * @param sysUserRoleRes 新权限-账号-角色关联表
	 * @return
	 */
	IPage<SysUserRoleRes> getSysUserRoleResPage(Page<SysUserRoleRes> page, SysUserRoleResSearchVo sysUserRoleRes);

	List<SysUserRoleRes> noPageDiy(SysUserRoleResSearchVo searchVo);

	/**
	 * @param roleId
	 * @Description: 根据角色id获取被使用的账号名称
	 * @Author: hgw
	 * @Date: 2023/9/8 17:38
	 * @return: java.util.List<java.lang.String>
	 **/
	List<String> getSysUserByRoleId(String roleId);

	/**
	 * @param userId
	 * @Description: 根据账号删除关联表
	 * @Author: hgw
	 * @Date: 2023/8/30 15:45
	 * @return: boolean
	 **/
	boolean deleteByUserId(String userId);

	/**
	 * @param roleId
	 * @Description: 根据角色删除关联表
	 * @Author: hgw
	 * @Date: 2023/8/30 15:45
	 * @return: boolean
	 **/
	boolean deleteByRoleId(String roleId);

}
