package com.yifu.cloud.plus.v1.permission.service.impl;/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.permission.mapper.SysUserRoleResMapper;
import com.yifu.cloud.plus.v1.permission.service.SysUserRoleResService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysUserRoleRes;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysUserRoleResSearchVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 新权限-账号-角色关联表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
@Log4j2
@Service
public class SysUserRoleResServiceImpl extends ServiceImpl<SysUserRoleResMapper, SysUserRoleRes> implements SysUserRoleResService {
	/**
	 * 新权限-账号-角色关联表简单分页查询
	 *
	 * @param sysUserRoleRes 新权限-账号-角色关联表
	 * @return
	 */
	@Override
	public IPage<SysUserRoleRes> getSysUserRoleResPage(Page<SysUserRoleRes> page, SysUserRoleResSearchVo sysUserRoleRes) {
		return baseMapper.getSysUserRoleResPage(page, sysUserRoleRes);
	}

	@Override
	public List<SysUserRoleRes> noPageDiy(SysUserRoleResSearchVo searchVo) {
		LambdaQueryWrapper<SysUserRoleRes> wrapper = buildQueryWrapper(searchVo);
		List<String> idList = Common.getList(searchVo.getIds());
		if (Common.isNotNull(idList)) {
			wrapper.in(SysUserRoleRes::getFdId, idList);
		}
		if (searchVo.getLimitStart() >= 0 && searchVo.getLimitEnd() > 0) {
			wrapper.last(" limit " + searchVo.getLimitStart() + "," + searchVo.getLimitEnd());
		}
		return baseMapper.selectList(wrapper);
	}

	/**
	 * @param roleId
	 * @Description: 根据角色id获取被使用的账号名称
	 * @Author: hgw
	 * @Date: 2023/9/8 17:38
	 * @return: java.util.List<java.lang.String>
	 **/
	@Override
	public List<String> getSysUserByRoleId(String roleId) {
		return baseMapper.getSysUserByRoleId(roleId);
	}

	@Override
	public boolean deleteByUserId(String userId) {
		return baseMapper.deleteByUserId(userId);
	}

	@Override
	public boolean deleteByRoleId(String roleId) {
		return baseMapper.deleteByRoleId(roleId);
	}

	private LambdaQueryWrapper buildQueryWrapper(SysUserRoleResSearchVo entity) {
		LambdaQueryWrapper<SysUserRoleRes> wrapper = Wrappers.lambdaQuery();
		return wrapper;
	}

}
