/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 薪资人员档案变更记录
 *
 * @author fxj
 * @date 2023-10-11 17:48:31
 */
@Data
@TableName("t_salary_emp_mod_log")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "薪资人员档案变更记录")
public class TSalaryEmpModLog extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * content
	 */
	@ExcelAttribute(name = "content", maxLength = 50)
	@Length(max = 50, message = "content不能超过50个字符")
	@ExcelProperty("content")
	@Schema(description = "content")
	private String content;
	/**
	 * 0编辑、1批量更新、2EKP变更银行卡号
	 */
	@ExcelAttribute(name = "0编辑、1批量更新、2EKP变更银行卡号", isNotEmpty = true, errorInfo = "0编辑、1批量更新、2EKP变更银行卡号不能为空", maxLength = 1)
	@NotBlank(message = "0编辑、1批量更新、2EKP变更银行卡号不能为空")
	@Length(max = 1, message = "0编辑、1批量更新、2EKP变更银行卡号不能超过1个字符")
	@ExcelProperty("0编辑、1批量更新、2EKP变更银行卡号")
	@Schema(description = "0编辑、1批量更新、2EKP变更银行卡号")
	private String type;

	/**
	 * idNum
	 */
	@ExcelAttribute(name = "idNum", maxLength = 20)
	@Length(max = 20, message = "idNum不能超过20个字符")
	@ExcelProperty("idNum")
	@Schema(description = "idNum")
	private String idNum;
	/**
	 * parentId
	 */
	@ExcelAttribute(name = "parentId", maxLength = 32)
	@Length(max = 32, message = "parentId不能超过32个字符")
	@ExcelProperty("parentId")
	@Schema(description = "parentId")
	private String parentId;

}
