/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * 全年一次性奖金申报表
 *
 * @author huyc
 * @date 2022-08-14 21:31:15
 */
@Data
@TableName("t_statistics_bonus")
@EqualsAndHashCode()
@Schema(description = "全年一次性奖金申报表")
public class TStatisticsBonus {

	/**
	 * ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelIgnore
	@Schema(description = "ID")
	private String id;
	/**
	 * 申报单位
	 */
	@ExcelAttribute(name = "申报单位", maxLength = 32)
	@Length(max = 32, message = "申报单位不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申报单位")
	@Schema(description = "申报单位")
	private String declareUnit;
	/**
	 * 申报月份（YYYYMM）
	 */
	@ExcelAttribute(name = "申报月份", isNotEmpty = true, errorInfo = "申报月份（YYYYMM）不能为空", maxLength = 6)
	@NotBlank(message = "申报月份（YYYYMM）不能为空")
	@Length(max = 6, message = "申报月份（YYYYMM）不能超过6个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("申报月份")
	@Schema(description = "申报月份（YYYYMM）")
	private String declareMonth;
	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "姓名", maxLength = 32)
	@Length(max = 32, message = "员工姓名不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("姓名")
	@Schema(description = "员工姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号码", maxLength = 32)
	@Length(max = 32, message = "身份证号不能超过32个字符")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号码")
	@Schema(description = "身份证号")
	private String empIdcard;
	/**
	 * 年终奖
	 */
	@ExcelAttribute(name = "年终奖（元）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("年终奖（元）")
	@Schema(description = "年终奖(元)")
	private BigDecimal annualBonus;
	/**
	 * 年终奖单独扣税应缴税额
	 */
	@ExcelAttribute(name = "年终奖单独扣税")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("年终奖单独扣税")
	@Schema(description = "年终奖单独扣税应缴税额")
	private BigDecimal bonusTax;
	/**
	 * 项目id
	 */
	@Schema(description = "项目id")
	@ExcelIgnore
	private String deptId;
	/**
	 * 项目编码
	 */
	@Schema(description = "项目编码")
	@ExcelIgnore
	private String deptNo;
	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	@ExcelIgnore
	private String deptName;
	/**
	 * 单位id
	 */
	@Schema(description = "单位id")
	@ExcelIgnore
	private String unitId;
	/**
	 * 单位编码
	 */
	@Schema(description = "单位编码")
	@ExcelIgnore
	private String unitNo;

}
