/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import cn.hutool.core.util.ArrayUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esotericsoftware.minlog.Log;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ExcelUtil;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryEmpModLog;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryEmployee;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TSalaryEmpModLogMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TSalaryEmpModLogService;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TSalaryEmpModLogSearchVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.List;
/**
 * 薪资人员档案变更记录
 *
 * @author fxj
 * @date 2023-10-11 17:48:31
 */
@Log4j2
@Service
public class TSalaryEmpModLogServiceImpl extends ServiceImpl<TSalaryEmpModLogMapper, TSalaryEmpModLog> implements TSalaryEmpModLogService {
    /**
     * 薪资人员档案变更记录简单分页查询
     * @param tSalaryEmpModLog 薪资人员档案变更记录
     * @return
     */
    @Override
    public IPage<TSalaryEmpModLog> getTSalaryEmpModLogPage(Page<TSalaryEmpModLog> page, TSalaryEmpModLogSearchVo tSalaryEmpModLog){
        return baseMapper.getTSalaryEmpModLogPage(page,tSalaryEmpModLog);
    }

    @Override
    public List<TSalaryEmpModLog> noPageDiy(TSalaryEmpModLogSearchVo searchVo) {
        LambdaQueryWrapper<TSalaryEmpModLog> wrapper = buildQueryWrapper(searchVo);
        List<String> idList = Common.getList(searchVo.getIds());
        if (Common.isNotNull(idList)){
            wrapper.in(TSalaryEmpModLog::getId,idList);
        }
        if (searchVo.getLimitStart() >= 0 && searchVo.getLimitEnd() > 0){
            wrapper.last(" limit "+ searchVo.getLimitStart() +","+ searchVo.getLimitEnd());
        }
        wrapper.orderByDesc(BaseEntity::getCreateTime);
        return baseMapper.selectList(wrapper);
    }
	/**
	 * @Author fxj
	 * @Description 记录变更日志
	 * @Date 17:59 2023/10/24
	 * @Param type  0 编辑 1 批量更新  3 EKP 更新
	 * @return
	**/
	@Override
	public void initModLog(TSalaryEmployee newEntity, TSalaryEmployee oldEntity, String type,String userName,ExcelUtil<TSalaryEmployee> util) {
		if (Common.isNotNull(newEntity) && Common.isNotNull(oldEntity)){
			TSalaryEmpModLog log = new TSalaryEmpModLog();
			log.setIdNum(newEntity.getEmpIdcard());
			log.setParentId(newEntity.getId());
			log.setType(type);
			log.setCreateName(userName);
			StringBuilder str = new StringBuilder();
			//编辑
			if (Common.isEmpty(util)){
				util = new ExcelUtil<>(TSalaryEmployee.class);
			}
			extracted(newEntity, oldEntity, str);
			//计税月份
			if (Common.isNotNull(newEntity.getTaxMonth()) && !oldEntity.getTaxMonth().equals(newEntity.getTaxMonth())){
				str.append("计税月份：");
				str.append(oldEntity.getTaxMonth());
				str.append("->");
				str.append(newEntity.getTaxMonth());
				str.append("  ");
			}
			//开户行省
			if (Common.isNotNull(newEntity.getBankProvince())
					&& !oldEntity.getBankProvince().equals(newEntity.getBankProvince())){
				str.append("开户行省：");
				str.append(Common.isEmpty(oldEntity.getBankProvince())?"":util.getAreaLabelPublic(oldEntity.getBankProvince()));
				str.append("->");
				str.append(Common.isEmpty(newEntity.getBankProvince())?"":util.getAreaLabelPublic(newEntity.getBankProvince()));
				str.append("  ");
			}
			//开户行市
			if (Common.isNotNull(newEntity.getBankCity())  && !oldEntity.getBankCity().equals(newEntity.getBankCity())){
				str.append("开户行市：");
				str.append(Common.isEmpty(oldEntity.getBankCity())?"":util.getAreaLabelPublic(oldEntity.getBankCity()));
				str.append("->");
				str.append(Common.isEmpty(newEntity.getBankCity())?"":util.getAreaLabelPublic(newEntity.getBankCity()));
				str.append("  ");
			}
			log.setContent(str.toString());
			Log.error("薪资人员变更记录表："+str.toString());
			if (Common.isNotNull(log.getContent())){
				baseMapper.insert(log);
			}
		}
	}

	private void extracted(TSalaryEmployee newEntity, TSalaryEmployee oldEntity, StringBuilder str) {
		//姓名
		if (Common.isNotNull(newEntity.getEmpName())
				&& !oldEntity.getEmpName().equals(newEntity.getEmpName())){
			str.append("员工姓名：");
			str.append(oldEntity.getEmpName());
			str.append("->");
			str.append(newEntity.getEmpName());
			str.append("  ");
		}
		//开户行
		if (Common.isNotNull(newEntity.getBankName())
				&& !oldEntity.getBankName().equals(newEntity.getBankName())){
			str.append("开户行：");
			str.append(oldEntity.getBankName());
			str.append("->");
			str.append(newEntity.getBankName());
			str.append("  ");
		}
		//银行卡号
		if (Common.isNotNull(newEntity.getBankNo())
				&& !oldEntity.getBankNo().equals(newEntity.getBankNo())){
			str.append("银行卡号：");
			str.append(oldEntity.getBankNo());
			str.append("->");
			str.append(newEntity.getBankNo());
			str.append("  ");
		}
		//开户行支行
		if ((Common.isEmpty(oldEntity.getBankSubName())
				&& Common.isNotNull(newEntity.getBankSubName()))
				|| (Common.isNotNull(newEntity.getBankSubName())
				&& !newEntity.getBankSubName().equals(oldEntity.getBankSubName()))){
			str.append("开户行支行：");
			str.append(oldEntity.getBankSubName());
			str.append("->");
			str.append(newEntity.getBankSubName());
			str.append("  ");
		}
		//在职状态
		if (Common.isNotNull(newEntity.getFileStatus())
				&& !oldEntity.getFileStatus().equals(newEntity.getFileStatus())){
			str.append("在职状态：");
			str.append(CommonConstants.ZERO_STRING.equals(oldEntity.getFileStatus())?"在职":"离职");
			str.append("->");
			str.append(CommonConstants.ZERO_STRING.equals(newEntity.getFileStatus())?"在职":"离职");
			str.append("  ");
		}
		//手机号码
		if (Common.isNotNull(newEntity.getEmpPhone())
				&& !oldEntity.getEmpPhone().equals(newEntity.getEmpPhone())){
			str.append("手机号码：");
			str.append(oldEntity.getEmpPhone());
			str.append("->");
			str.append(newEntity.getEmpPhone());
			str.append("  ");
		}
	}

	private LambdaQueryWrapper buildQueryWrapper(TSalaryEmpModLogSearchVo entity){
        LambdaQueryWrapper<TSalaryEmpModLog> wrapper = Wrappers.lambdaQuery();
        if (ArrayUtil.isNotEmpty(entity.getCreateTimes())) {
            wrapper.ge(TSalaryEmpModLog::getCreateTime, entity.getCreateTimes()[0])
                    .le(TSalaryEmpModLog::getCreateTime,
                            entity.getCreateTimes()[1]);
        }
        if (Common.isNotNull(entity.getCreateName())){
            wrapper.eq(TSalaryEmpModLog::getCreateName,entity.getCreateName());
        }
        return wrapper;
    }

}
