package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.social.entity.TDispatchInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

/**
 * @Author fxj
 * @Date 2022/7/27
 * @Description
 * @Version 1.0
 */
@Data
public class SocialHandleSearchVo extends TDispatchInfo {
	//派单开始时间（查询专用）
	@ExcelAttribute(name = "创建开始时间")
	@TableField(exist = false)
	private LocalDateTime createTimeStart;
	//派单截止时间（查询专用）
	@ExcelAttribute(name = "创建截止时间")
	@TableField(exist = false)
	private LocalDateTime createTimeEnd;

	/**
	 * 多选导出或删除等操作
	 */
	@TableField(exist = false)
	@Schema(description = "员工类型下拉多选" )
	@ExcelIgnore
	String[]empTypeList;

	/**
	 * 社保户
	 */
	@Schema(description = "社保户" )
	@TableField(exist = false)
	private String socialHouseholdName;

	/**
	 * 公积金户
	 */
	@Schema(description = "公积金户" )
	@TableField(exist = false)
	private String providentHouseholdName;

	/**
	 * @Author fxj
	 * 查询数据起
	 **/
	private int limitStart;
	/**
	 * @Author fxj
	 * 查询数据止
	 **/
	private int limitEnd;

	private String idStr;

	/**
	 * 审核时间开始时间
	 */
	@TableField(exist = false)
	@Schema(description = "审核时间开始时间" )
	@ExcelIgnore
	private String auditTimeStart;
	/**
	 * 审核时间截止时间
	 */
	@TableField(exist = false)
	@Schema(description = "审核时间截止时间" )
	@ExcelIgnore
	private String auditTimeEnd;

	/**
	 * 派单项：如 养老、公积金
	 */
	@ExcelAttribute(name = "派单项查询")
	@Schema(description = "派单项查询" )
	private List<String> dispatchItems;

	/**
	 * 菜单id
	 */
	@TableField(exist = false)
	@Schema(description = "mid" )
	@ExcelIgnore
	private String mId;

	/**
	 * 单位编号
	 */
	@TableField(exist = false)
	@Schema(description ="单位编号")
	@ExcelIgnore
	private String customerNo;

	/**
	 * 单位统一信用代码
	 */
	@TableField(exist = false)
	@Schema(description ="单位统一信用代码")
	@ExcelIgnore
	private String unitCreditCode;

	/**
	 * 派单增/减月份
	 */
	@TableField(exist = false)
	@Schema(description ="派单增/减月份")
	@ExcelIgnore
	private String disMonth;

	@Schema(description = "导出的表头的Set")
	private Set<String> exportFields;

	/**
	 * 审核状态 0 通过 1 不通过
	 */
	@ExcelAttribute(name = "审核状态")
	@ExcelIgnore
	@Schema(description = "审核状态")
	private String auditStatus;
}
