/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 缴费库导出参数
 * @author huyc
 * @date 2022-10-31 17:01:22
 */
@Data
public class TPaymentInfoExportVo extends RowIndex implements Serializable {

	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名" )
	@Schema(description ="员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;

	/**
	 * 员工编码
	 */
	@ExcelAttribute(name = "员工编码" )
	@Schema(description ="员工编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工编码")
	private String empNo;

	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号" )
	@Schema(description ="身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;

	/**
	 * 客户名称
	 */
	@ExcelAttribute(name = "客户名称" )
	@Schema(description ="客户名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	private String unitName;

	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称" )
	@Schema(description ="项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String settleDomainName;

	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", maxLength = 50)
	@Schema(description = "项目编码" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码" )
	private String settleDomainCode;

	/**
	 * 社保户
	 */
	@ExcelAttribute(name = "社保户" )
	@Schema(description ="社保户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户")
	private String socialHousehold;

	/**
	 * 社保编号
	 */
	@ExcelAttribute(name = "社保编号" )
	@Schema(description ="社保编号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保编号")
	private String socialSecurityNo;

	/**
	 * 社保缴纳地
	 */
	@ExcelAttribute(name = "社保缴纳地" )
	@Schema(description ="社保缴纳地")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地")
	private String socialPayAddr;

	/**
	 * 社保缴纳月份
	 */
	@ExcelAttribute(name = "社保缴纳月份")
	@Schema(description ="社保缴纳月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳月份")
	private String socialPayMonth;

	/**
	 * 社保生成月份
	 */
	@ExcelAttribute(name = "社保生成月份")
	@Schema(description ="社保生成月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保生成月份")
	private String socialCreateMonth;

	/**
	 * 总合计
	 */
	@ExcelAttribute(name = "总合计" )
	@Schema(description ="总合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("总合计")
	private BigDecimal sumAll;

	/**
	 * 公积金缴纳月份
	 */
	@ExcelAttribute(name = "公积金缴纳月份")
	@Schema(description ="公积金缴纳月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳月份")
	private String providentPayMonth;

	/**
	 * 公积金生成月份
	 */
	@ExcelAttribute(name = "公积金生成月份")
	@Schema(description ="公积金生成月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金生成月份")
	private String providentCreateMonth;

	/**
	 * 公积金户
	 */
	@ExcelAttribute(name = "公积金户" )
	@Schema(description ="公积金户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金户")
	private String providentHousehold;

	/**
	 * 公积金缴纳地
	 */
	@ExcelAttribute(name = "公积金缴纳地" )
	@Schema(description ="公积金缴纳地")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地")
	private String providentPayAddr;

	/**
	 * 社保合计
	 */
	@ExcelAttribute(name = "社保合计" )
	@Schema(description ="社保合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保合计")
	private BigDecimal socialSum;

	/**
	 * 单位社保合计
	 */
	@ExcelAttribute(name = "单位社保合计" )
	@Schema(description ="单位社保合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位社保合计")
	private BigDecimal unitSocialSum;

	/**
	 * 个人社保合计
	 */
	@ExcelAttribute(name = "个人社保合计" )
	@Schema(description ="个人社保合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人社保合计")
	private BigDecimal socialSecurityPersonalSum;

	/**
	 * 公积金总合计
	 */
	@ExcelAttribute(name = "公积金总合计" )
	@Schema(description ="公积金总合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金总合计")
	private BigDecimal providentSum;

	/**
	 * 就职班组
	 */
	@ExcelAttribute(name = "就职班组" )
	@Schema(description ="就职班组")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("就职班组")
	private String inauguralTeam;

	/**
	 * 单位社保补缴利息
	 */
	@ExcelAttribute(name = "单位社保补缴利息"  )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位社保补缴利息")
	private BigDecimal companyAccrual;
	/**
	 * 个人社保补缴利息
	 */
	@ExcelAttribute(name = "个人社保补缴利息"  )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人社保补缴利息")
	private BigDecimal personalAccrual;
	/**
	 * 单位养老基数
	 */
	@ExcelAttribute(name = "单位养老基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老基数")
	private BigDecimal unitPensionSet;
	/**
	 * 单位医疗基数
	 */
	@ExcelAttribute(name = "单位医疗基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗基数")
	private BigDecimal unitMedicalSet;
	/**
	 * 单位失业基数
	 */
	@ExcelAttribute(name = "单位失业基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业基数")
	private BigDecimal unitUnemploymentSet;
	/**
	 * 单位工伤基数
	 */
	@ExcelAttribute(name = "单位工伤基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤基数")
	private BigDecimal unitInjurySet;
	/**
	 * 单位生育基数
	 */
	@ExcelAttribute(name = "单位生育基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育基数")
	private BigDecimal unitBirthSet;
	/**
	 * 单位养老金额
	 */
	@ExcelAttribute(name = "单位养老金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老金额")
	private BigDecimal unitPensionMoney;
	/**
	 * 单位医疗金额
	 */
	@ExcelAttribute(name = "单位医疗金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗金额")
	private BigDecimal unitMedicalMoney;
	/**
	 * 单位失业金额
	 */
	@ExcelAttribute(name = "单位失业金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业金额")
	private BigDecimal unitUnemploymentMoney;
	/**
	 * 单位工伤金额
	 */
	@ExcelAttribute(name = "单位工伤金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤金额")
	private BigDecimal unitInjuryMoney;
	/**
	 * 单位生育金额
	 */
	@ExcelAttribute(name = "单位生育金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育金额")
	private BigDecimal unitBirthMoney;
	/**
	 * 单位大病金额
	 */
	@ExcelAttribute(name = "单位大病金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病金额")
	private BigDecimal unitBigmailmentMoney;
	/**
	 * 个人养老金额
	 */
	@ExcelAttribute(name = "个人养老金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老金额")
	private BigDecimal personalPensionMoney;
	/**
	 * 个人医疗金额
	 */
	@ExcelAttribute(name = "个人医疗金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗金额")
	private BigDecimal personalMedicalMoney;
	/**
	 * 个人失业金额
	 */
	@ExcelAttribute(name = "个人失业金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业金额")
	private BigDecimal personalUnemploymentMoney;
	/**
	 * 个人大病金额
	 */
	@ExcelAttribute(name = "个人大病金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病金额")
	private BigDecimal personalBigmailmentMoney;
	/**
	 * 公积金编号
	 */
	@ExcelAttribute(name = "公积金编号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金编号")
	private String providentNo;
	/**
	 * 单位公积金基数
	 */
	@ExcelAttribute(name = "单位公积金基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金基数")
	private BigDecimal unitProvidentSet;
	/**
	 * 单位公积金比例
	 */
	@ExcelAttribute(name = "单位公积金比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金比例")
	private BigDecimal providentPercent;
	/**
	 * 单位公积金费用
	 */
	@ExcelAttribute(name = "单位公积金费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金费用")
	private BigDecimal unitProvidentSum;
	/**
	 * 个人公积金基数
	 */
	@ExcelAttribute(name = "个人公积金基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金基数")
	private BigDecimal personalProidentSet;
	/**
	 * 个人公积金费用
	 */
	@ExcelAttribute(name = "个人公积金费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金费用")
	private BigDecimal personalProvidentSum;

	/**
	 * 社保创建人姓名
	 */
	@ExcelAttribute(name = "社保创建人姓名")
	@Schema(description = "社保创建人姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保创建人姓名")
	private String socialCreateName;
	/**
	 * 社保创建时间
	 */
	@Schema(description = "社保创建时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保创建时间")
	private String socialCreateTime;
	/**
	 * 公积金创建人姓名
	 */
	@ExcelAttribute(name = "公积金创建人姓名")
	@Schema(description = "公积金创建人姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金创建人姓名")
	private String fundCreateName;
	/**
	 * 公积金创建时间
	 */
	@Schema(description = "公积金创建时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金创建时间")
	private String fundCreateTime;
	/**
	 * 分组键
	 */
	@ExcelAttribute(name = "分组键", isExport = false)
	@Schema(description = "分组键")
	private String keyGroup;


}
