/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author huyc
 * @date 2022-07-25 14:08:58
 */
@Data
public class TPaymentInfoImportLogVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@ExcelAttribute(name = "id", isNotEmpty = true, errorInfo = "主键 不能为空")
	@Schema(description = "主键")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("主键")
	private Integer id;
	/**
	 * 姓名
	 */
	@Length(max = 50, message = "姓名 不能超过50 个字符")
	@ExcelAttribute(name = "empName", maxLength = 50)
	@Schema(description = "姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@Length(max = 32, message = "身份证号 不能超过32 个字符")
	@ExcelAttribute(name = "idCard", maxLength = 32)
	@Schema(description = "身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String idCard;
	/**
	 * 错误信息
	 */
	@Length(max = 500, message = "错误信息 不能超过500 个字符")
	@ExcelAttribute(name = "errMsg", maxLength = 500)
	@Schema(description = "错误信息")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("错误信息")
	private String errMsg;
	/**
	 * 问题行数
	 */
	@ExcelAttribute(name = "line")
	@Schema(description = "问题行数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("问题行数")
	private Integer line;
	/**
	 * 导入标识key
	 */
	@Length(max = 64, message = "导入标识key 不能超过64 个字符")
	@ExcelAttribute(name = "randomKey", maxLength = 64)
	@Schema(description = "导入标识key")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("导入标识key")
	private String randomKey;

}
