/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import com.yifu.cloud.plus.v1.yifu.social.util.BigDecimalConverter;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 缴费库
 * @author huyc
 * @date 2022-07-22 17:01:22
 */
@Data
public class TPaymentInfoVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Length(max = 32, message = "主键 不能超过32 个字符")
	@ExcelAttribute(name = "主键", maxLength = 32)
	@Schema(description = "主键")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "主键")
	private String id;
	/**
	 * 员工姓名
	 */
	@Length(max = 20, message = "员工姓名 不能超过20 个字符")
	@ExcelAttribute(name = "员工姓名", maxLength = 20,isNotEmpty = true)
	@Schema(description = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工姓名")
	private String empName;
	/**
	 * 员工编码
	 */
	@Length(max = 32, message = "员工编码 不能超过32 个字符")
	@ExcelAttribute(name = "员工编码", maxLength = 32)
	@Schema(description = "员工编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工编码")
	private String empNo;
	/**
	 * 员工ID
	 */
	@NotBlank(message = "员工ID 不能为空")
	@Length(max = 32, message = "员工ID 不能超过32 个字符")
	@ExcelAttribute(name = "员工ID", maxLength = 32)
	@Schema(description = "员工ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "员工ID")
	private String empId;
	/**
	 * 身份证号
	 */
	@Length(max = 20, message = "身份证号 不能超过20 个字符")
	@ExcelAttribute(name = "身份证号", maxLength = 20, isNotEmpty = true,errorInfo = "身份证字段不可为空！")
	@Schema(description = "身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "身份证号")
	private String empIdcard;
	/**
	 * 项目id
	 */
	@ExcelAttribute(name = "项目id")
	@Schema(description ="项目id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "项目id")
	private String settleDomainId;

	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Schema(description ="项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "项目名称")
	private String settleDomainName;

	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", maxLength = 50)
	@Schema(description = "项目编码" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "项目编码" )
	private String settleDomainCode;
	/**
	 * 客户名称
	 */
	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@Schema(description ="客户名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "客户名称")
	private String unitName;

	/**
	 * 客户Id
	 */
	@ExcelAttribute(name = "客户Id" )
	@Schema(description ="客户Id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "客户Id")
	private String unitId;
	/**
	 * 社保户
	 */
	@Length(max = 32, message = "社保户 不能超过32 个字符")
	@ExcelAttribute(name = "社保户", maxLength = 32)
	@Schema(description = "社保户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保户")
	private String socialHousehold;
	/**
	 * 社保编号
	 */
	@Length(max = 20, message = "社保编号 不能超过20 个字符")
	@ExcelAttribute(name = "社保编号", maxLength = 20)
	@Schema(description = "社保编号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保编号")
	private String socialSecurityNo;
	/**
	 * 社保缴纳地
	 */
	@Length(max = 50, message = "社保缴纳地 不能超过50 个字符")
	@ExcelAttribute(name = "社保缴纳地", maxLength = 50)
	@Schema(description = "社保缴纳地")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保缴纳地")
	private String socialPayAddr;
	/**
	 * 社保缴纳月份
	 */
	@ExcelAttribute(name = "社保缴纳月份", maxLength = 6, min = 6,isInteger = true)
	@Schema(description = "社保缴纳月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保缴纳月份")
	private String socialPayMonth;
	/**
	 * 社保生成月份
	 */
	@ExcelAttribute(name = "社保生成月份", maxLength = 6, min = 6,isInteger = true)
	@Schema(description = "社保生成月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保生成月份")
	private String socialCreateMonth;
	/**
	 * 锁定状态 0 未锁定 1 锁定
	 */
	@Length(max = 1, message = "锁定状态 0 未锁定 1 锁定 不能超过1 个字符")
	@ExcelAttribute(name = "锁定状态 0 未锁定 1 锁定", maxLength = 1)
	@Schema(description = "锁定状态 0 未锁定 1 锁定")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "锁定状态 0 未锁定 1 锁定")
	private String lockStatus;
	/**
	 * 总合计
	 */
	@ExcelAttribute(name = "总合计")
	@Schema(description = "总合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "总合计", converter = BigDecimalConverter.class)
	private BigDecimal sumAll;
	/**
	 * 公积金缴纳月份
	 */
	@ExcelAttribute(name = "公积金缴纳月份", maxLength = 6, min = 6,isInteger = true)
	@Schema(description = "公积金缴纳月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "公积金缴纳月份")
	private String providentPayMonth;
	/**
	 * 公积金生成月份
	 */
	@ExcelAttribute(name = "公积金生成月份", maxLength = 6, min = 6,isInteger = true)
	@Schema(description = "公积金生成月份")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "公积金生成月份")
	private String providentCreateMonth;
	/**
	 * 公积金户
	 */
	@Length(max = 32, message = "公积金户 不能超过32 个字符")
	@ExcelAttribute(name = "公积金户", maxLength = 32)
	@Schema(description = "公积金户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "公积金户")
	private String providentHousehold;
	/**
	 * 公积金缴纳地
	 */
	@Length(max = 50, message = "公积金缴纳地 不能超过50 个字符")
	@ExcelAttribute(name = "公积金缴纳地", maxLength = 50)
	@Schema(description = "公积金缴纳地")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "公积金缴纳地")
	private String providentPayAddr;
	/**
	 * 公积金缴纳地-省
	 */
	@Length(max = 32, message = "公积金缴纳地-省 不能超过32 个字符")
	@ExcelAttribute(name = "公积金缴纳地-省", maxLength = 32)
	@Schema(description = "公积金缴纳地-省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "公积金缴纳地-省")
	private String fundProvince;
	/**
	 * 公积金缴纳地-市
	 */
	@Length(max = 32, message = "公积金缴纳地-市 不能超过32 个字符")
	@ExcelAttribute(name = "公积金缴纳地-市", maxLength = 32)
	@Schema(description = "公积金缴纳地-市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "公积金缴纳地-市")
	private String fundCity;
	/**
	 * 公积金缴纳地-县
	 */
	@Length(max = 32, message = "公积金缴纳地-县 不能超过32 个字符")
	@ExcelAttribute(name = "公积金缴纳地-县", maxLength = 32)
	@Schema(description = "公积金缴纳地-县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "公积金缴纳地-县")
	private String fundTown;
	/**
	 * 社保缴纳地-省
	 */
	@Length(max = 32, message = "社保缴纳地-省 不能超过32 个字符")
	@ExcelAttribute(name = "社保缴纳地-省", maxLength = 32)
	@Schema(description = "社保缴纳地-省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保缴纳地-省")
	private String socialProvince;
	/**
	 * 社保缴纳地-市
	 */
	@Length(max = 32, message = "社保缴纳地-市 不能超过32 个字符")
	@ExcelAttribute(name = "社保缴纳地-市", maxLength = 32)
	@Schema(description = "社保缴纳地-市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保缴纳地-市")
	private String socialCity;
	/**
	 * 社保缴纳地-县
	 */
	@Length(max = 32, message = "社保缴纳地-县 不能超过32 个字符")
	@ExcelAttribute(name = "社保缴纳地-县", maxLength = 32)
	@Schema(description = "社保缴纳地-县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保缴纳地-县")
	private String socialTown;
	/**
	 * 社保ID
	 */
	@Length(max = 32, message = "社保ID 不能超过32 个字符")
	@ExcelAttribute(name = "社保ID", maxLength = 32)
	@Schema(description = "社保ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保ID")
	private String socialId;
	/**
	 * 公积金ID
	 */
	@Length(max = 32, message = "公积金ID 不能超过32 个字符")
	@ExcelAttribute(name = "公积金ID", maxLength = 32)
	@Schema(description = "公积金ID")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "公积金ID")
	private String fundId;
	/**
	 * 社保合计
	 */
	@ExcelAttribute(name = "社保合计")
	@Schema(description = "社保合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "社保合计", converter = BigDecimalConverter.class)
	private BigDecimal socialSum;
	/**
	 * 单位社保合计
	 */
	@ExcelAttribute(name = "单位社保合计")
	@Schema(description = "单位社保合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "单位社保合计", converter = BigDecimalConverter.class)
	private BigDecimal unitSocialSum;
	/**
	 * 个人社保合计
	 */
	@ExcelAttribute(name = "个人社保合计")
	@Schema(description = "个人社保合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "个人社保合计", converter = BigDecimalConverter.class)
	private BigDecimal socialSecurityPersonalSum;
	/**
	 * 公积金总合计
	 */
	@ExcelAttribute(name = "公积金总合计")
	@Schema(description = "公积金总合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "公积金总合计", converter = BigDecimalConverter.class)
	private BigDecimal providentSum;
	/**
	 * 就职班组
	 */
	@Length(max = 50, message = "就职班组 不能超过50 个字符")
	@ExcelAttribute(name = "就职班组", maxLength = 50)
	@Schema(description = "就职班组")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "就职班组")
	private String inauguralTeam;
	/**
	 * 单位补缴利息
	 */
	@ExcelAttribute(name = "单位补缴利息", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description ="单位补缴利息")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "单位补缴利息", converter = BigDecimalConverter.class)
	private BigDecimal companyAccrual;
	/**
	 * 个人补缴利息
	 */
	@ExcelAttribute(name = "个人补缴利息", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description ="个人补缴利息")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "个人补缴利息", converter = BigDecimalConverter.class)
	private BigDecimal personalAccrual;
	/**
	 * 养老基数
	 */
	@ExcelAttribute(name = "养老基数", isFloat = true,max = "999999999.99")
	@Schema(description ="养老基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "养老基数", converter = BigDecimalConverter.class)
	private BigDecimal unitPensionSet;
	/**
	 * 医保基数
	 */
	@ExcelAttribute(name = "医保基数", isFloat = true,max = "999999999.99")
	@Schema(description ="医保基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "医保基数", converter = BigDecimalConverter.class)
	private BigDecimal unitMedicalSet;
	/**
	 * 失业基数
	 */
	@ExcelAttribute(name = "失业基数", isFloat = true,max = "999999999.99")
	@Schema(description ="失业基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "失业基数", converter = BigDecimalConverter.class)
	private BigDecimal unitUnemploymentSet;
	/**
	 * 工伤基数
	 */
	@ExcelAttribute(name = "工伤基数", isFloat = true,max = "999999999.99")
	@Schema(description ="工伤基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "工伤基数", converter = BigDecimalConverter.class)
	private BigDecimal unitInjurySet;
	/**
	 * 生育基数
	 */
	@ExcelAttribute(name = "生育基数", isFloat = true,max = "999999999.99")
	@Schema(description ="生育基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "生育基数", converter = BigDecimalConverter.class)
	private BigDecimal unitBirthSet;
	/**
	 * 单位养老比例
	 */
	@ExcelAttribute(name = "单位养老比例")
	@Schema(description ="单位养老比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "单位养老比例", converter = BigDecimalConverter.class)
	private BigDecimal unitPensionPer;
	/**
	 * 单位医疗比例
	 */
	@ExcelAttribute(name = "单位医疗比例")
	@Schema(description ="单位医疗比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "单位医疗比例", converter = BigDecimalConverter.class)
	private BigDecimal unitMedicalPer;
	/**
	 * 单位失业比例
	 */
	@ExcelAttribute(name = "单位失业比例")
	@Schema(description ="单位失业比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "单位失业比例", converter = BigDecimalConverter.class)
	private BigDecimal unitUnemploymentPer;
	/**
	 * 单位工伤比例
	 */
	@ExcelAttribute(name = "单位工伤比例")
	@Schema(description ="单位工伤比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "单位工伤比例", converter = BigDecimalConverter.class)
	private BigDecimal unitInjuryPer;
	/**
	 * 单位生育比例
	 */
	@ExcelAttribute(name = "单位生育比例")
	@Schema(description ="单位生育比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "单位生育比例", converter = BigDecimalConverter.class)
	private BigDecimal unitBirthPer;
	/**
	 * 个人养老比例
	 */
	@ExcelAttribute(name = "个人养老比例")
	@Schema(description ="个人养老比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "个人养老比例", converter = BigDecimalConverter.class)
	private BigDecimal personalPensionPer;
	/**
	 * 个人医疗比例
	 */
	@ExcelAttribute(name = "个人医疗比例")
	@Schema(description ="个人医疗比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "个人医疗比例", converter = BigDecimalConverter.class)
	private BigDecimal personalMedicalPer;
	/**
	 * 个人失业比例
	 */
	@ExcelAttribute(name = "个人失业比例")
	@Schema(description ="个人失业比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "个人失业比例", converter = BigDecimalConverter.class)
	private BigDecimal personalUnemploymentPer;
	/**
	 * 单位大病比例
	 */
	@ExcelAttribute(name = "单位大病比例")
	@Schema(description ="单位大病比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "单位大病比例", converter = BigDecimalConverter.class)
	private BigDecimal unitBigailmentPer;
	/**
	 * 个人大病比例
	 */
	@ExcelAttribute(name = "个人大病比例")
	@Schema(description ="个人大病比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "个人大病比例", converter = BigDecimalConverter.class)
	private BigDecimal personalBigailmentPer;
	/**
	 * 养老单位缴费
	 */
	@ExcelAttribute(name = "养老单位缴费", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description ="养老单位缴费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "养老单位缴费", converter = BigDecimalConverter.class)
	private BigDecimal unitPensionMoney;
	/**
	 * 医保单位缴费
	 */
	@ExcelAttribute(name = "医保单位缴费", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description ="医保单位缴费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "医保单位缴费", converter = BigDecimalConverter.class)
	private BigDecimal unitMedicalMoney;
	/**
	 * 失业单位缴费
	 */
	@ExcelAttribute(name = "失业单位缴费", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description ="失业单位缴费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "失业单位缴费", converter = BigDecimalConverter.class)
	private BigDecimal unitUnemploymentMoney;
	/**
	 * 工伤缴费
	 */
	@ExcelAttribute(name = "工伤缴费", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description ="工伤缴费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "工伤缴费", converter = BigDecimalConverter.class)
	private BigDecimal unitInjuryMoney;
	/**
	 * 生育缴费
	 */
	@ExcelAttribute(name = "生育缴费", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description ="生育缴费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "生育缴费", converter = BigDecimalConverter.class)
	private BigDecimal unitBirthMoney;
	/**
	 * 单位医疗救助金
	 */
	@ExcelAttribute(name = "单位医疗救助金", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description ="单位医疗救助金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "单位医疗救助金", converter = BigDecimalConverter.class)
	private BigDecimal unitBigmailmentMoney;
	/**
	 * 养老个人缴费
	 */
	@ExcelAttribute(name = "养老个人缴费", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description ="养老个人缴费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "养老个人缴费", converter = BigDecimalConverter.class)
	private BigDecimal personalPensionMoney;
	/**
	 * 医保个人缴费
	 */
	@ExcelAttribute(name = "医保个人缴费", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description ="医保个人缴费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "医保个人缴费", converter = BigDecimalConverter.class)
	private BigDecimal personalMedicalMoney;
	/**
	 * 失业个人缴费
	 */
	@ExcelAttribute(name = "失业个人缴费", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description ="失业个人缴费")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "失业个人缴费", converter = BigDecimalConverter.class)
	private BigDecimal personalUnemploymentMoney;
	/**
	 * 个人医疗救助金
	 */
	@ExcelAttribute(name = "个人医疗救助金", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description ="个人医疗救助金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "个人医疗救助金", converter = BigDecimalConverter.class)
	private BigDecimal personalBigmailmentMoney;
	/**
	 * 公积金编号
	 */
	@Length(max=20,message = "公积金编号不能超过20个字符")
	@ExcelAttribute(name = "公积金编号", maxLength = 20 )
	@Schema(description ="公积金编号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "公积金编号")
	private String providentNo;
	/**
	 * 公积金单边基数
	 */
	@ExcelAttribute(name = "公积金单边基数", isFloat = true,max = "999999999.99")
	@Schema(description ="公积金单边基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "公积金单边基数", converter = BigDecimalConverter.class)
	private BigDecimal unitProvidentSet;
	/**
	 * 公积金单边比例
	 */
	@ExcelAttribute(name = "公积金单边比例", isFloat = true,max = "100.00")
	@Schema(description ="公积金单边比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "公积金单边比例", converter = BigDecimalConverter.class)
	private BigDecimal providentPercent;
	/**
	 * 公积金单边金额
	 */
	@ExcelAttribute(name = "公积金单边金额", isFloat = true,max = "999999999.99", min= -999999999)
	@Schema(description ="公积金单边金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "公积金单边金额", converter = BigDecimalConverter.class)
	private BigDecimal unitProvidentSum;
	/**
	 * 个人公积金基数
	 */
	@ExcelAttribute(name = "个人公积金基数", isFloat = true,max = "999999999.99")
	@Schema(description ="个人公积金基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "个人公积金基数", converter = BigDecimalConverter.class)
	private BigDecimal personalProidentSet;
	/**
	 * 个人公积金费用
	 */
	@ExcelAttribute(name = "个人公积金费用")
	@Schema(description ="个人公积金费用")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "个人公积金费用", converter = BigDecimalConverter.class)
	private BigDecimal personalProvidentSum;
	/**
	 * 创建者
	 */
	@Length(max = 64, message = "创建者 不能超过64 个字符")
	@ExcelAttribute(name = "创建者", maxLength = 64)
	@Schema(description = "创建者")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "创建者")
	private String createBy;
	/**
	 * 更新人
	 */
	@Length(max = 64, message = "更新人 不能超过64 个字符")
	@ExcelAttribute(name = "更新人", maxLength = 64)
	@Schema(description = "更新人")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "更新人")
	private String updateBy;
	/**
	 * 创建人姓名
	 */
	@Length(max = 32, message = "创建人姓名 不能超过32 个字符")
	@ExcelAttribute(name = "创建人姓名", maxLength = 32)
	@Schema(description = "创建人姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "创建人姓名")
	private String createName;
	/**
	 * 创建时间
	 */
	@ExcelAttribute(name = "创建时间", isDate = true)
	@Schema(description = "创建时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "创建时间")
	private Date createTime;
	/**
	 * 更新时间
	 */
	@ExcelAttribute(name = "更新时间", isDate = true)
	@Schema(description = "更新时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "更新时间")
	private Date updateTime;

}
