/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.social.entity.TDispatchInfo;
import com.yifu.cloud.plus.v1.yifu.social.vo.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 派单信息记录表
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Mapper
public interface TDispatchInfoMapper extends BaseMapper<TDispatchInfo> {
    /**
     * 派单信息记录表简单分页查询
     * @param tDispatchInfo 派单信息记录表
     * @return
     */
    IPage<TDispatchInfoPageVo> getTDispatchInfoPage(Page<TDispatchInfo> page, @Param("tDispatchInfo") TDispatchInfoSearchVo tDispatchInfo);

	IPage<TDispatchInfoPageVo> getTDispatchInfoPageAudit(Page<TDispatchInfo> page, @Param("tDispatchInfo") TDispatchInfoSearchVo tDispatchInfo);

	/**
	 * @Description: 派单导出
	 * @Author: hgw
	 * @Date: 2022/7/28 10:45
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.social.vo.TDispatchInfoExportVo>
	 **/
	List<TDispatchInfoExportVo> exportDispatch(@Param("tDispatchInfo") TDispatchInfoSearchVo tDispatchInfo);

	/**
	 * @Description: 派单审核导出
	 * @Author: huyc
	 * @Date: 2022/10/22 14:45
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.social.vo.TDispatchAuditExportVo>
	 **/
	List<TDispatchAuditExportVo> exportAuditDispatch(@Param("tDispatchInfo") TDispatchInfoSearchVo tDispatchInfo);

	long selectExportCount(@Param("tDispatchInfo") TDispatchInfoSearchVo tDispatchInfo);

	/**
	 * 导出社保花名册数据查询
	 * @Author fxj
	 * @Date 2019-10-12
	 * @param dispatchInfo
	 * @param idsStr
	 * @return
	 **/
	List<SocialHandleExportVo> getSocialRecordRosterList(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo,
														 @Param("idsStr") List<String> idsStr);
	/**
	 * @Author fxj
	 * @Description 导出社保花名册数据更新导出状态
	 * @Date 16:20 2023/5/9
	 * @Param
	 * @return
	**/
	int updateSocialRecords(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo,
														 @Param("idsStr") List<String> idsStr);

	/**
	 * 导出社保花名册数据查询count
	 * @Author fxj
	 * @Date 2019-10-12
	 * @param dispatchInfo
	 * @param idsStr
	 * @return
	 **/
	int getSocialRecordRosterListCount(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo,
									   @Param("idsStr") List<String> idsStr);
	/**
	 * 社保页面查询
	 * @Author fxj
	 * @Date 2019-10-12
	 * @param tDispatchInfo
	 * @return
	 **/
	IPage<TDispatchInfo> getTDispatchSocialHandlePage(Page<TDispatchInfo> page,
													  @Param("tDispatchInfo") SocialHandleSearchVo tDispatchInfo,
													  @Param("idsStr") List<String> idsStr);

	/**
	 * 社保页面查询
	 * @Author fxj
	 * @Date 2019-10-12
	 * @param tDispatchInfo
	 * @return
	 **/
	List<TDispatchInfo> getTDispatchSocialHandleNoPage(@Param("tDispatchInfo")SocialHandleSearchVo tDispatchInfo,
														@Param("idCards") List<String> idCards,
													  	@Param("idsStr") List<String> idsStr);
	/**
	 * 公积金办理页面查询
	 * @Author fxj
	 * @Date 2019-10-12
	 * @param tDispatchInfo
	 * @return
	 **/
	IPage<TDispatchInfo> getTDispatchFundHandlePage(Page<TDispatchInfo> page,
													@Param("tDispatchInfo")SocialHandleSearchVo tDispatchInfo,
													@Param("idsStr") List<String> idsStr);

	/**
	 * 公积金办理查询
	 * @Author fxj
	 * @Date 2019-10-12
	 * @param tDispatchInfo
	 * @return
	 **/
	List<TDispatchInfo> getTDispatchFundHandleNoPage(@Param("tDispatchInfo")SocialHandleSearchVo tDispatchInfo,
													@Param("idCards") List<String> idCards,@Param("idsStr") List<String> idsStr);
	/**
	 * @Author fxj
	 * @Description 公积金补交清册
	 * @Date 19:47 2022/7/27
	 * @Param
	 * @return
	**/
	List<FundSupplementaryExportVo> getFundSupplementaryRecords(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo,
																@Param("settleDomainIds")List<String> settleDomainIds,
																@Param("idsStr") List<String> idsStr,
																@Param("sql") String sql);
	/**
	 * @Author fxj
	 * @Description 公积金变更清册cout
	 * @Date 19:47 2022/7/27
	 * @Param
	 * @return
	**/
	int getFundRecordCount(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo,
						   @Param("idsStr") List<String> idsStr);

	/**
	 * @Author huyc
	 * @Description 社保派单医保模版count
	 * @Date 15:47 2023/7/18
	 * @Param
	 * @return
	 **/
	int getSocialDisRecordCount(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo);


	int getFCount(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo);

	/**
	 * @Author huyc
	 * @Description 社保派单医保模版
	 * @Date 15:47 2023/7/18
	 * @Param
	 * @return
	 **/
	List<TDispatchSocialExportVo> getSocialDisRecord(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo);

	/**
	 * @Author huyc
	 * @Description 社保派单医保模版
	 * @Date 15:47 2023/7/18
	 * @Param
	 * @return
	 **/
	List<TDispatchSocialExportVo> getSocialReduceDisRecord(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo);

	/**
	 * @Author huyc
	 * @Description 社保派单养老模版count
	 * @Date 15:47 2023/7/18
	 * @Param
	 * @return
	 **/
	int getSocialPersionDisCount(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo);

	/**
	 * @Author huyc
	 * @Description 社保派单养老模版
	 * @Date 15:47 2023/7/18
	 * @Param
	 * @return
	 **/
	List<TDispatchSocialPersionExportVo> getSocialPersionDisRecord(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo);

	/**
	 * @Author huyc
	 * @Description 社保派单养老模版count
	 * @Date 15:47 2023/7/18
	 * @Param
	 * @return
	 **/
	int getSocialPersionReduceDisCount(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo);

	/**
	 * @Author huyc
	 * @Description 社保派单养老模版
	 * @Date 15:47 2023/7/18
	 * @Param
	 * @return
	 **/
	List<TDispatchSocialPersionReduceExportVo> getSocialPersionReduceDisRecord(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo);

	List<FundHandleExportVo> getFundRecordList(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo,
											   @Param("idsStr") List<String> idsStr);
	/**
	 * @Author fxj
	 * @Description  公积金变更清楚 导出状态更新
	 * @Date 16:16 2023/5/9
	 * @Param
	 * @return
	**/
	int updateFundRecords(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo,
											   @Param("idsStr") List<String> idsStr);

	String getMaxDispatchCode();

	int updateExportSocialFlagById(@Param("id")String id,@Param("status")String status);

	int updateExportFundFlagById(@Param("id")String id,@Param("status")String status);

	List<TDispatchFundPersionExportVo> getFundPersionExportVo(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo);

	List<TDispatchFundSupplementaryExportVo> getFundSupplementarynExportVo(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo);

	TDispatchFundSumExportVo getFundSumExportVo(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo);

	TDispatchFundSumVo getFundSumExportVoOne(@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo);

	CompanyProVo getFundPersionExportVoOne(@Param("houseName") String houseName,@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo);

	HouseNameConfigVo getFundSumExportVoTwo(@Param("houseName") String houseName,@Param("tDispatchInfo") SocialHandleSearchVo dispatchInfo);
}
