/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.social.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.social.entity.TProvidentFund;
import com.yifu.cloud.plus.v1.yifu.social.vo.FundAddAndReduceVo;
import com.yifu.cloud.plus.v1.yifu.social.vo.TProvidentFundSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;
/**
 * 公积金信息
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
public interface TProvidentFundService extends IService<TProvidentFund> {
    /**
     * 公积金信息简单分页查询
     * @param tProvidentFund 公积金信息
     * @return
     */
    IPage<TProvidentFund> getTProvidentFundPage(Page<TProvidentFund> page, TProvidentFundSearchVo tProvidentFund);

    R<List<ErrorMessage>> importDiy(InputStream inputStream);

    void listExport(HttpServletResponse response, TProvidentFundSearchVo searchVo);

    List<TProvidentFund> noPageDiy(TProvidentFundSearchVo searchVo);

	/**
	 * B端使用-通过ID查询员工对应的派增派减数据
	 * @Author fxj
	 * @Date 2020-08-25
	 * @param empId
	 * @return
	 **/
	FundAddAndReduceVo getAddOrReduceInfoByEmpId(String empId);
}
