/*
 * Copyright (c) 2020 yifu4cloud Authors. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.yifu.cloud.plus.v1.yifu.admin.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.admin.api.entity.SysRole;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.BusinessRoleMenuVo;
import com.yifu.cloud.plus.v1.yifu.admin.api.vo.RoleExcelVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import org.springframework.validation.BindingResult;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * 服务类
 * </p>
 *
 * @author lengleng
 * @since 2019/2/1
 */
public interface SysRoleService extends IService<SysRole> {

	/**
	 * 通过角色ID，删除角色
	 * @param id
	 * @return
	 */
	R<Boolean> removeRoleById(Long id);

	/**
	 * 导入角色
	 * @param excelVOList 角色列表
	 * @param bindingResult 错误信息列表
	 * @return ok fail
	 */
	R importRole(List<RoleExcelVO> excelVOList, BindingResult bindingResult);

	/**
	 * 查询全部的角色
	 * @return list
	 */
	List<RoleExcelVO> listRole();

	Page<SysRole> getSysRoleByPage(Page page, SysRole sysRole);
	/**
	 * 更新角色信息
	 * @param sysRole
	 * @return
	 */
	void updateRoleById(SysRole sysRole);

	/**
	 * @Author fxj
	 * @Description  验证角色名称和角色编码
	 * @Date 17:23 2022/6/14
	 * @Param
	 * @return
	**/
	R<Boolean> getBooleanR(SysRole sysRole);

	/**
	 * 获取b角色菜单集合
	 * @param type 0 菜单 1 按钮 null所有
	 * @return
	 **/
	List<BusinessRoleMenuVo> getRoleAndMenu(String type);

	/**
	 * 获取该用户在此客户端的所有角色id
	 * @param userId
	 * @param clientId
	 * @return
	 **/
	Set<String> getRoleByUserIdAndClient(String userId, String clientId);
}
