/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAutoFundRuleRel;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoFundRuleRelSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.archives.service.TAutoFundRuleRelService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 公积金购买规则明细表
 *
 * @author fxj
 * @date 2025-11-06 16:26:07
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tautofundrulerel")
@Tag(name = "社保购买规则明细表管理")
public class TAutoFundRuleRelController {

	private final TAutoFundRuleRelService tAutoFundRuleRelService;


	/**
	 * 简单分页查询
	 *
	 * @param page             分页对象
	 * @param tAutoFundRuleRel 社保购买规则明细表
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TAutoFundRuleRel>> getTAutoFundRuleRelPage(Page<TAutoFundRuleRel> page, TAutoFundRuleRelSearchVo tAutoFundRuleRel) {
		return new R<>(tAutoFundRuleRelService.getTAutoFundRuleRelPage(page, tAutoFundRuleRel));
	}

	/**
	 * 不分页查询
	 *
	 * @param tAutoFundRuleRel 社保购买规则明细表
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	//@PreAuthorize("@pms.hasPermission('social_tautofundrulerel_get')" )
	public R<List<TAutoFundRuleRel>> getTAutoFundRuleRelNoPage(@RequestBody TAutoFundRuleRelSearchVo tAutoFundRuleRel) {
		return R.ok(tAutoFundRuleRelService.noPageDiy(tAutoFundRuleRel));
	}

	/**
	 * 通过id查询社保购买规则明细表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('social_tautofundrulerel_get')")
	@GetMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('social_tautofundrulerel_get')")
	public R<TAutoFundRuleRel> getById(@PathVariable("id") String id) {
		return R.ok(tAutoFundRuleRelService.getById(id));
	}

	/**
	 * 新增社保购买规则明细表
	 *
	 * @param tAutoFundRuleRel 社保购买规则明细表
	 * @return R
	 */
	@Operation(summary = "新增社保购买规则明细表", description = "新增社保购买规则明细表：hasPermission('social_tautofundrulerel_add')")
	@SysLog("新增社保购买规则明细表")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('social_tautofundrulerel_add')")
	public R<Boolean> save(@RequestBody TAutoFundRuleRel tAutoFundRuleRel) {
		return R.ok(tAutoFundRuleRelService.save(tAutoFundRuleRel));
	}

	/**
	 * 修改社保购买规则明细表
	 *
	 * @param tAutoFundRuleRel 社保购买规则明细表
	 * @return R
	 */
	@Operation(summary = "修改社保购买规则明细表", description = "修改社保购买规则明细表：hasPermission('social_tautofundrulerel_edit')")
	@SysLog("修改社保购买规则明细表")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('social_tautofundrulerel_edit')")
	public R<Boolean> updateById(@RequestBody TAutoFundRuleRel tAutoFundRuleRel) {
		return R.ok(tAutoFundRuleRelService.updateById(tAutoFundRuleRel));
	}

	/**
	 * 通过id删除社保购买规则明细表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除社保购买规则明细表", description = "通过id删除社保购买规则明细表：hasPermission('social_tautofundrulerel_del')")
	@SysLog("通过id删除社保购买规则明细表")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('social_tautofundrulerel_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		return R.ok(tAutoFundRuleRelService.removeById(id));
	}

}
