package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * 入职确认信息已购买商险明细
 *
 * @author huych
 * @date 2025-08-05 15:08:42
 */
@Data
@TableName("t_insurance_pre_detail")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "入职确认信息已购买商险明细")
public class TInsurancePreDetail extends BaseEntity {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键")
	@Schema(description = "主键")
	private String id;
	/**
	 * 姓名
	 */
	@ExcelAttribute(name = "姓名", maxLength = 32)
	@Length(max = 32, message = "姓名不能超过32个字符")
	@ExcelProperty("姓名")
	@Schema(description = "姓名")
	private String empName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, errorInfo = "身份证号不能为空", maxLength = 32)
	@NotBlank(message = "身份证号不能为空")
	@Length(max = 32, message = "身份证号不能超过32个字符")
	@ExcelProperty("身份证号")
	@Schema(description = "身份证号")
	private String empIdcardNo;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", maxLength = 30)
	@Length(max = 30, message = "项目编码不能超过30个字符")
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String deptNo;
	/**
	 * 投保岗位
	 */
	@ExcelAttribute(name = "投保岗位", maxLength = 32)
	@Length(max = 32, message = "投保岗位不能超过32个字符")
	@ExcelProperty("投保岗位")
	@Schema(description = "投保岗位")
	private String post;
	/**
	 * 保险公司名称
	 */
	@ExcelAttribute(name = "保险公司名称", maxLength = 60)
	@Length(max = 60, message = "保险公司名称不能超过60个字符")
	@ExcelProperty("保险公司名称")
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;
	/**
	 * 险种名称
	 */
	@ExcelAttribute(name = "险种名称", maxLength = 50)
	@Length(max = 50, message = "险种名称不能超过50个字符")
	@ExcelProperty("险种名称")
	@Schema(description = "险种名称")
	private String insuranceTypeName;
	/**
	 * 购买标准
	 */
	@ExcelAttribute(name = "购买标准", maxLength = 32)
	@Length(max = 32, message = "购买标准不能超过32个字符")
	@ExcelProperty("购买标准")
	@Schema(description = "购买标准")
	private String buyStandard;
	/**
	 * 保单开始时间
	 */
	@ExcelAttribute(name = "保单开始时间", isDate = true)
	@ExcelProperty("保单开始时间")
	@Schema(description = "保单开始时间")
	@JsonFormat(shape= JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd", timezone = "GMT+08:00")
	private Date policyStart;
	/**
	 * 保单结束时间
	 */
	@ExcelAttribute(name = "保单结束时间", isDate = true)
	@ExcelProperty("保单结束时间")
	@Schema(description = "保单结束时间")
	@JsonFormat(shape= JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd", timezone = "GMT+08:00")
	private Date policyEnd;
	/**
	 * 保单生效日期
	 */
	@ExcelAttribute(name = "保单生效日期", isDate = true)
	@ExcelProperty("保单生效日期")
	@Schema(description = "保单生效日期")
	@JsonFormat(shape= JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd", timezone = "GMT+08:00")
	private Date policyEffect;
	/**
	 * 投保类型， 1新增、3批增、4替换
	 */
	@ExcelAttribute(name = "购买类型， 1新增、3批增、4替换")
	@ExcelProperty("投保类型， 1新增、3批增、4替换")
	@Schema(description = "投保类型， 1新增、3批增、4替换")
	private Integer buyType;
	/**
	 * 投保办理状态 1待投保 2投保中 3已投保 4投保退回 5 已减员
	 */
	@ExcelAttribute(name = "投保办理状态 1待投保 2投保中 3已投保 4投保退回 5 已减员")
	@ExcelProperty("投保办理状态 1待投保 2投保中 3已投保 4投保退回 5 已减员")
	@Schema(description = "投保办理状态 1待投保 2投保中 3已投保 4投保退回 5 已减员")
	private Integer buyHandleStatus;
	/**
	 * 结算主体名称
	 */
	@ExcelAttribute(name = "结算主体名称", maxLength = 50)
	@Length(max = 50, message = "结算主体名称不能超过50个字符")
	@ExcelProperty("结算主体名称")
	@Schema(description = "结算主体名称")
	private String deptName;
	/**
	 * 客户名称
	 */
	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@Length(max = 50, message = "客户名称不能超过50个字符")
	@ExcelProperty("客户名称")
	@Schema(description = "客户名称")
	private String unitName;
	/**
	 * 客户编码
	 */
	@ExcelAttribute(name = "客户编码", maxLength = 32)
	@Length(max = 32, message = "客户编码不能超过32个字符")
	@ExcelProperty("客户编码")
	@Schema(description = "客户编码")
	private String unitNo;
	/**
	 * 是否地市自购0是 1 否
	 */
	@ExcelAttribute(name = "是否地市自购0是 1 否", maxLength = 1)
	@Length(max = 1, message = "是否地市自购0是 1 否不能超过1个字符")
	@ExcelProperty("是否地市自购0是 1 否")
	@Schema(description = "是否地市自购0是 1 否")
	private String isAdress;
	/**
	 * 入离职登记id
	 */
	@ExcelAttribute(name = "入离职登记id", maxLength = 32)
	@Length(max = 32, message = "入离职登记id不能超过32个字符")
	@ExcelProperty("入离职登记id")
	@Schema(description = "入离职登记id")
	private String registerId;

	/**
	 * 商险购买地省
	 */
	@Schema(description = "商险购买地省")
	private String insuranceProvinceName;
	/**
	 * 商险购买地市
	 */
	@Schema(description = "商险购买地市")
	private String insuranceCityName;

	/**
	 * 派单时间
	 */
	@ExcelAttribute(name = "派单时间", isDate = true)
	@ExcelProperty("派单时间")
	@Schema(description = "派单时间")
	@TableField(exist = false)
	@JsonFormat(shape= JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd", timezone = "GMT+08:00")
	private Date disTime;

}
