/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TDeptSee;
import com.yifu.cloud.plus.v1.yifu.salary.vo.TDeptSeeSearchVo;

import java.util.List;

/**
 * 项目薪资查询权限配置表-薪资配置1
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
public interface TDeptSeeService extends IService<TDeptSee> {
    /**
     * 项目薪资查询权限配置表-薪资配置1简单分页查询
     * @param tDeptSee 项目薪资查询权限配置表-薪资配置1
     * @return
     */
    IPage<TDeptSee> getTDeptSeePage(Page<TDeptSee> page, TDeptSeeSearchVo tDeptSee);

    List<TDeptSee> noPageDiy(TDeptSeeSearchVo searchVo);
}
