/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryAccountItem;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryEmployee;
import com.yifu.cloud.plus.v1.yifu.salary.vo.*;

import javax.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * 薪酬人员表
 *
 * @author hgw
 * @date 2022-08-05 11:40:14
 */
public interface TSalaryEmployeeService extends IService<TSalaryEmployee> {
    /**
     * 薪酬人员表简单分页查询
     * @param tSalaryEmployee 薪酬人员表
     * @return
     */
    IPage<TSalaryEmployee> getTSalaryEmployeePage(Page<TSalaryEmployee> page, TSalaryEmployeeSearchVo tSalaryEmployee);

    R<List<ErrorMessage>> importDiy(InputStream inputStream);

    void listExport(HttpServletResponse response, TSalaryEmployeeSearchVo searchVo);

    List<TSalaryEmployeeExportVo> noPageDiy(TSalaryEmployeeSearchVo searchVo);

	TSalaryAccountItem selectByIdcard(String idCard,String nowMonth);

	/**
	 * @param notLabour 是：非劳务费人员。 否：劳务费，不保存
	 * @param employee
	 * @Description: 新建薪资员工，返回值为null，保存成功。其余都是失败原因
	 * @Author: hgw
	 * @Date: 2022/8/17 16:03
	 * @return: java.lang.String
	 **/
	String saveNewSalaryEmployee(boolean notLabour, TSalaryEmployee employee);

	/**
	 * @param saveNewEmpList
	 * @param errorList
	 * @Description: 批量新增人员，包含批量判断，减少判断时间等
	 * @Author: hgw
	 * @Date: 2023/2/9 14:57
	 * @return: java.lang.String
	 **/
	String saveNewEmployeeList(List<TSalaryEmployee> saveNewEmpList, List<ErrorMessage> errorList, Map<String, Integer> phoneExcelMap);

	/**
	 * @Description: 更新卡号等信息
	 * @Author: hgw
	 * @Date: 2024/7/22 10:27
	 * @return: java.lang.String
	 **/
	String updateEmployeeBankList(List<TSalaryEmployee> updateEmpBankList, Map<String, TSalaryEmployee> updateEmpBankMap
			, List<ErrorMessage> errorList, Map<String, Integer> phoneExcelMap);

	/**
	 * @param inputStream
	 * @Description: 批量更新-薪资人员信息
	 * @Author: hgw
	 * @Date: 2022/10/10 17:17
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage>>
	 **/
	R<List<ErrorMessage>> batchUpdateSalaryEmployee(InputStream inputStream);

	/**
	 * @param vo
	 * @Description: 批量新增或更新人员
	 * @Author: hgw
	 * @Date: 2023/1/17 15:38
	 * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List < com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage>>
	 **/
	R<List<ErrorMessage>> importEmployee(SalaryEmployeeImportVo vo);

	TSalaryEmployee getByEmpIdCard(String empIdCard);

	/**
	 * @param idCardList
	 * @Description: 批量获取员工
	 * @Author: hgw
	 * @Date: 2023/2/8 14:29
	 * @return: java.util.Map<java.lang.String, com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryEmployee>
	 **/
	Map<String, TSalaryEmployee> getByEmpIdCardList(List<String> idCardList);

	/**
	 * @param employee
	 * @Description: 代发户的，下次校验银行卡，同时变更校验flag
	 * @Author: hgw
	 * @Date: 2023/1/10 18:09
	 * @return: boolean
	 **/
	boolean checkBankInfo(TSalaryEmployee employee);

	boolean checkBankInfoList(List<TSalaryEmployee> empList, List<ErrorMessage> errorList);

	/**
	 * @param vo
	 * @Description: 同步ekp薪酬人员信息
	 * @Author: huyc
	 * @Date: 2023/04/18 11:38
	 * @return {@link R}
	 **/
	R updateEmployeeFromEkp(TSalaryEmployeeEkpUpdateVo vo);

    List<TSalaryEmpRosterVo> getSalaryEmpRoster(List<String> idCardList);

	R<Boolean> updateByIdDiy(TSalaryEmployee tSalaryEmployee);

	/**
	 * @param empIdCard 身份证
	 * @Description: C端预入职获取计税月份
	 * @Author: hgw
	 * @Date: 2024/7/16 16:11
	 * @return: java.lang.String
	 **/
	String getEmpTaxMonth(String empIdCard);

	/**
	 * @param empIdCard 身份证
	 * @Description: C端预入职获取薪资人员信息
	 * @Author: hgw
	 * @Date: 2024/7/23 11:22
	 * @return: com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryEmployee
	 **/
	TSalaryEmployee getSalaryEmployee(String empIdCard);

	/**
	 * @Description: 保存
	 * @Author: hgw
	 * @Date: 2024/7/23 11:22
	 * @return: java.lang.String
	 **/
	String savePreNewEmpInfo(TSalaryEmployee newEmp);

	/**
	 * @param empIdCardList 身份证
	 * @Description: 获取薪资人员信息
	 * @Author: hgw
	 * @Date: 2025/1/13 17:33
	 * @return: java.util.Map<java.lang.String, com.yifu.cloud.plus.v1.yifu.salary.entity.TSalaryEmployee>
	 **/
	Map<String, TSalaryEmployee> getSalaryEmpMap(List<String> empIdCardList);

}
