package com.yifu.cloud.plus.v1.yifu.archives.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeContractPreVo;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TEmployeeInsurancePre;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * 入职待建档表
 *
 * @author huych
 * @date 2025-03-12 17:14:19
 */
@Data
@TableName("employee_registration_pre")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "入职待建档表")
public class EmployeeRegistrationPre extends BaseEntity {

	/**
	 * 主键ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键ID")
	private String id;

	@Schema(description = "员工姓名")
	private String employeeName;

	@Schema(description = "身份证号")
	private String empIdcard;

	@Schema(description = "手机号码")
	private String empPhone;

	@Schema(description = "就职岗位")
	private String position;

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "入职日期")
	private Date joinLeaveDate;

	@Schema(description = "状态,0短信待发送,1信息待填写,2信息待审核,3拒绝入职,4已完成")
	private String processStatus;

	@Schema(description = "前端客服")
	private String customerUsername;

	@Schema(description = "前端客服登录名")
	private String customerUserLoginname;

	@Schema(description = "项目名称")
	private String deptName;

	@Schema(description = "项目编码")
	private String deptNo;

	@Schema(description = "项目id")
	private String deptId;

	@Schema(description = "员工类型（字典值，0外包1派遣2代理）")
	private String empNature;

	@Schema(description = "合同类型（字典值）")
	private String contractType;

	@Schema(description = "合同业务细分（字典值）")
	private String contractSubName;

	@Schema(description = "数据来源")
	private String dataSource;

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "预计收集时间")
	private LocalDateTime expectedCollectionTime;

	@Schema(description = "服务事项")
	private String serverItem;

	@Schema(description = "档案所在地-省")
	private String fileProvince;

	@Schema(description = "档案所在地-市")
	private String fileCity;

	@Schema(description = "档案所在地-县")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String fileTown;

	@Schema(description = "档案所在地-省编号")
	private String provinceCode;

	@Schema(description = "档案所在地-市编号")
	private String cityCode;

	@Schema(description = "档案所在地-县编号")
	@TableField(updateStrategy = FieldStrategy.IGNORED)
	private String townCode;

	@Schema(description = "确认人")
	private String confirmUser;

	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd HH:mm:ss")
	@Schema(description = "确认时间")
	private Date confirmTime;

	@Schema(description = "最新的客服名称")
	private String customerUsernameNew;

	@Schema(description = "拒绝入职原因")
	@TableField(exist = false)
	private String reason;

	@Schema(description = "商险配置列表")
	@TableField(exist = false)
	private List<TEmployeeInsurancePre> insurancePreList;

	@Schema(description = "合同待派单信息")
	@TableField(exist = false)
	private TEmployeeContractPreVo employeeContractPreVo;

	@Schema(description = "附件集合")
	@TableField(exist = false)
	private List<TAttaInfo> attaList;

	/**
	 * 附件Id
	 */
	@TableField(exist = false)
	private List<String> attaIdList;

}
