/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.alibaba.excel.annotation.write.style.ColumnWidth;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * HCM档案子Vo
 * @author hgw
 * @date 2023-11-23 12:02:03
 */
@Data
@ColumnWidth(30)
public class HcmArchiveBasicVo implements Serializable {

	private static final long serialVersionUID = 1L;

	@Schema(description = "员工姓名")
	private String empName;

	@Schema(description = "身份证号")
	private String empIdCard;

	@Schema(description = "邮箱")
	private String email;

	@Schema(description = "出生日期")
	private String bornDate;

	@Schema(description = "性别")
	private String sex;

	@Schema(description = "最高学历")
	private String education;
	// 户口性质
	@Schema(description = "户口类型")
	private String residentType;

	@Schema(description = "婚姻状况")
	private String maritalStatus;

	@Schema(description = "民族")
	private String nation;
	// 户籍所在地
	@Schema(description = "籍贯")
	private String nativePlace;

	@Schema(description = "政治面貌")
	private String political;
	// 通讯地址
	@Schema(description = "联系地址")
	private String contactAddress;

}
