/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.vo;

import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzOfferInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDate;
import java.util.List;

/**
 * 瓜子offer信息接收表
 *
 * @author chenyx
 * @date 2025-06-11 15:58:37
 */
@Data
public class TGzOfferInfoVo extends TGzOfferInfo {

//	@Schema(description = "人员类别展示值")
//	private String empTypeLabel;
//
//	@Schema(description = "外签类型展示值")
//	private String outSginTypeLabel;

	/**
	 * 查询使用:接收时间开始
	 */
	private LocalDate createTimeStart;
	/**
	 * 查询使用:接收时间结束
	 */
	private LocalDate createTimeEnd;

	/**
	 * 批量发送短信使用
	 */
	@Schema(description = "选中ID,id数组")
	private List<String> idList;

}
