/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TGzOfferInfoVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TGzOfferInfo;
import com.yifu.cloud.plus.v1.yifu.archives.service.TGzOfferInfoService;
import lombok.SneakyThrows;
import org.springframework.security.access.prepost.PreAuthorize;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;


/**
 * 瓜子offer信息接收表
 *
 * @author chenyx
 * @date 2025-06-11 15:58:37
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tgzofferinfo" )
@Tag(name = "瓜子offer信息接收表管理")
public class TGzOfferInfoController {

    private final  TGzOfferInfoService tGzOfferInfoService;


    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tGzOfferInfo 瓜子offer信息接收表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TGzOfferInfoVo>> getTGzOfferInfoPage(Page<TGzOfferInfoVo> page, TGzOfferInfoVo tGzOfferInfo) {
        return  new R<>(tGzOfferInfoService.getTGzOfferInfoPage(page,tGzOfferInfo));
    }


    /**
     * 通过id查询瓜子offer信息接收表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询：hasPermission('archives_tgzofferinfo_get')")
    @GetMapping("/{id}" )
    public R<TGzOfferInfo> getById(@PathVariable("id" ) Integer id) {
        return R.ok(tGzOfferInfoService.getDataById(id));
    }

	/**
	 * 修改瓜子offer信息接收表
	 * @param tGzOfferInfo 瓜子offer信息接收表
	 * @return R
	 */
	@Operation(summary = "修改瓜子offer信息接收表")
	@SysLog("修改瓜子offer信息接收表" )
	@PutMapping
	// @PreAuthorize("@pms.hasPermission('archives_tgzofferinfo_edit')" )
	public R<String> updateById(@RequestBody TGzOfferInfo tGzOfferInfo) {
		return tGzOfferInfoService.updateDataById(tGzOfferInfo);
	}

	/**
	 * 瓜子offer手动状态更新
	 * @param tGzOfferInfo 瓜子offer信息接收表
	 * @return R
	 */
	@Operation(summary = "瓜子offer手动状态更新")
	@SysLog("瓜子offer手动状态更新" )
	@PutMapping("/updateStatus")
	// @PreAuthorize("@pms.hasPermission('archives_tgzofferinfo_edit')" )
	public R<String> updateStatus(@RequestBody TGzOfferInfo tGzOfferInfo) {
		return tGzOfferInfoService.updateStatus(tGzOfferInfo);
	}

    /**
     * 新增瓜子offer信息接收表
     * @param tGzOfferInfo 瓜子offer信息接收表
     * @return R
     */
    @Operation(summary = "新增瓜子offer信息接收表", description = "新增瓜子offer信息接收表：hasPermission('archives_tgzofferinfo_add')")
    @SysLog("新增瓜子offer信息接收表" )
    @PostMapping
    @PreAuthorize("@pms.hasPermission('archives_tgzofferinfo_add')" )
    public R<Boolean> save(@RequestBody TGzOfferInfo tGzOfferInfo) {
        return R.ok(tGzOfferInfoService.save(tGzOfferInfo));
    }

	/**
	 * 批量导入瓜子offer
	 * @author hgw
	 * @date 2025-06-16 14:29:13
	 **/
	@SneakyThrows
	@Operation(description = "批量导入瓜子offer")
	@SysLog("批量导入瓜子offer")
	@PostMapping("/importGzOfferList")
	public R<List<ErrorMessage>> importGzOfferList(@RequestBody MultipartFile file){
		return tGzOfferInfoService.importDiy(file.getInputStream());
	}


	/**
	 * 新增瓜子offer信息接收表
	 * @param tGzOfferInfo 瓜子offer信息接收表
	 * @return R
	 */
	@Operation(summary = "单个/批量发送Offer提醒", description = "单个/批量发送Offer提醒")
	@SysLog("单个/批量发送Offer提醒" )
	@PostMapping("/sendOfferAlert")
	public R<Boolean> sendOfferAlert(@RequestBody TGzOfferInfoVo tGzOfferInfo) {
		return tGzOfferInfoService.sendOfferAlert(tGzOfferInfo);
	}

}
