/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCompleteMonitorSetBaseInfo;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.TCompleteMonitorSetBaseInfoMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.TCompleteMonitorSetBaseInfoService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 完整度监控配置
 *
 * @author hgw
 * @date 2025-02-26 15:18:51
 */
@Log4j2
@Service
public class TCompleteMonitorSetBaseInfoServiceImpl extends ServiceImpl<TCompleteMonitorSetBaseInfoMapper, TCompleteMonitorSetBaseInfo> implements TCompleteMonitorSetBaseInfoService {

	@Override
	public List<TCompleteMonitorSetBaseInfo> getListByBaseType(String baseType) {
		LambdaQueryWrapper<TCompleteMonitorSetBaseInfo> wrapper = Wrappers.lambdaQuery();
		if (Common.isNotNull(baseType)) {
			wrapper.in(TCompleteMonitorSetBaseInfo::getBaseType, baseType);
		}
		wrapper.orderByAsc(TCompleteMonitorSetBaseInfo::getId);
		return baseMapper.selectList(wrapper);
	}

	/**
	 * @param typeName 类型名称
	 * @Description: 
	 * @Author: hgw
	 * @Date: 2025/2/27 21:19
	 * @return: java.util.List<java.lang.String>
	 **/
	@Override
	public List<String> getBaseFieldByTypeName(String typeName) {
		String[] idArr = null;
		String ids = baseMapper.getIdByType(typeName);
		// 取默认配置
		if (Common.isEmpty(ids) || "-1".equals(ids)) {
			ids = baseMapper.getIdByOne();
		}
		if (Common.isNotNull(ids)) {
			idArr = ids.split(",");
		}
		if (idArr == null || idArr.length == 0) {
			// -1表示不可以
			List<String> stringList = new ArrayList<>();
			stringList.add("-1");
			return stringList;
		}
		return baseMapper.getBaseFieldByIdArr(idArr);
	}

}
