package com.yifu.cloud.plus.v1.yifu.insurances.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceDetailService;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.*;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import java.util.List;

/**
 * @author zhangyun
 * @description 减员退费控制器
 * @date 2022-12-09 09:55:28
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/insuranceRefund")
@Tag(name = "商险减员退费相关")
@Validated
public class TInsuranceRefundController {

	@Resource
	private TInsuranceDetailService tInsuranceDetailService;

	/**
	 * 减员退费分页列表
	 *
	 * @author zhangyun
	 * @param page 分页信息
	 * @param param 筛选条件
	 * @param mId 菜单Id
	 * @return {@link R}
	 */
	@Operation(summary = "减员退费分页列表", description = "减员退费分页列表")
	@GetMapping("/getInsuranceRefundMoneyPageList")
	public R getInsuranceRefundPageList(Page<RefundListVo> page,
										InsuranceRefundHandlingParam param,
										@RequestParam(required = false) String mId) {
		return tInsuranceDetailService.getInsuranceRefundMoneyPageList(page,param,mId);
	}

	/**
	 * 减员退费不分页列表
	 *
	 * @author zhangyun
	 * @param param 筛选条件
	 * @return {@link R}
	 */
	@Operation(summary = "已减员列表导出", description = "已减员列表导出")
	@GetMapping("/getInsuranceRefundMoneyList")
	@PreAuthorize("@pms.hasPermission('insurance_custserve_reduction_export')")
	public R getInsuranceRefundList(InsuranceRefundHandlingParam param) {
		return tInsuranceDetailService.getInsuranceRefundMoneyList(param);
	}

	/**
	 * 更新减员退费
	 *
	 * @author zhangyun
	 * @param  paramList 退费列表
	 * @return {@link R<List<RefundMoneyUpdateParam>>}
	 */
	@Operation(summary = "更新减员退费", description = "更新减员退费")
	@PostMapping("/updateRefundMoney")
	@PreAuthorize("@pms.hasPermission('insurance_custserve_reduction_money')")
	public R updateRefundMoney(@RequestBody @Valid @Size(min = 1,message = "更新减员退费不能为空") List<RefundMoneyUpdateParam> paramList) {
		return tInsuranceDetailService.updateRefundMoney(paramList);
	}
}
