package com.yifu.cloud.plus.v1.yifu.salary.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.salary.entity.TOwnDept;
import com.yifu.cloud.plus.v1.yifu.salary.mapper.TOwnDeptMapper;
import com.yifu.cloud.plus.v1.yifu.salary.service.TOwnDeptService;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author fxj
 * @Description 自有员工所在结算主体大全表
 * @Date 13:18 2022/8/6
 * @Param
 * @return
**/
@Service("tOwnDeptService")
public class TOwnDeptServiceImpl extends ServiceImpl<TOwnDeptMapper, TOwnDept> implements TOwnDeptService {

     /**
      * 自有员工所在结算主体大全表简单分页查询
      *
      * @param tOwnDept 自有员工所在结算主体大全表
      * @return
      */
     @Override
     public IPage<TOwnDept> getTOwnDeptPage(Page<TOwnDept> page, TOwnDept tOwnDept) {
          return baseMapper.getTOwnDeptPage(page, tOwnDept);
     }

     /**
      * @param
      * @Description: 获取自有员工结算主体id
      * @Author: hgw
      * @Date: 2021/12/28 10:44
      * @return: java.util.List<java.lang.String>
      **/
     @Override
     public Map<String, Integer> getOwnDeptMap() {
          Map<String, Integer> ownDeptMap = new HashMap<>();
          List<String> ownDeptList = baseMapper.getTOwnDeptIdList();
          if (ownDeptList != null && !ownDeptList.isEmpty()) {
               for (String s : ownDeptList) {
                    ownDeptMap.put(s, CommonConstants.ZERO_INT);
               }
          }
          return ownDeptMap;
     }

     /**
      * 自有员工所在结算主体Map
      */
     @Override
     public Map<String, Integer> getOwnEmpMap() {
          Map<String, Integer> ownEmpMap = new HashMap<>();
          List<String> ownEmpList = baseMapper.getOwnEmpList();
          if (ownEmpList != null && !ownEmpList.isEmpty()) {
               for (String s : ownEmpList) {
                    ownEmpMap.put(s, CommonConstants.ZERO_INT);
               }
          }
          return ownEmpMap;
     }

}
