/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.social.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttributeConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import javax.validation.constraints.Size;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 社保公积金查询-导出使用
 *
 * @author fxj
 * @date 2022-07-15 11:38:05
 */
@Schema(description = "社保公积金查询-导出使用" )
@Data
public class TSocialFundInfoExportVo extends RowIndex implements Serializable {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "id")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("id")
	private String id;

	@ExcelAttribute(name = "项目编码", maxLength = 50)
	@Schema(description = "项目编码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目编码")
	private String settleDomainCode;

	@ExcelAttribute(name = "员工姓名", maxLength = 50)
	@Schema(description = "员工姓名")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工姓名")
	private String empName;

	@ExcelAttribute(name = "身份证号", maxLength = 20)
	@Schema(description = "身份证号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证号")
	private String empIdcard;

	@ExcelAttribute(name = "员工类型", isDataId = true,dataType = ExcelAttributeConstants.EMP_NATRUE)
	@Schema(description = "员工类型")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("员工类型")
	private String empType;

	@ExcelAttribute(name = "手机号码", maxLength = 32)
	@Schema(description = "手机号码")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("手机号码")
	private String empMobile;

	@ExcelAttribute(name = "客户名称", maxLength = 50)
	@Schema(description = "客户名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("客户名称")
	private String unitName;
	@ExcelAttribute(name = "项目名称", maxLength = 50)
	@Schema(description = "项目名称")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("项目名称")
	private String settleDomainName;

	@ExcelAttribute(name = "身份证省", isArea = true)
	@Schema(description = "身份证省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证省")
	private String idCardProvince;

	@ExcelAttribute(name = "身份证市", isArea = true, parentField = "idCardProvince")
	@Schema(description = "身份证市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证市")
	private String idCardCity;

	@ExcelAttribute(name = "身份证县", isArea = true, parentField = "idCardCity")
	@Schema(description = "身份证县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证县")
	private String idCardTown;

	@ExcelAttribute(name = "身份证所在地")
	@Schema(description = "身份证所在地")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("身份证所在地")
	private String idCardAddress;

	@ExcelAttribute(name = "档案-省", isArea = true)
	@Schema(description = "档案-省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("档案-省")
	private String fileProvince;

	@ExcelAttribute(name = "档案-市", isArea = true, parentField = "fileProvince")
	@Schema(description = "档案-市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("档案-市")
	private String fileCity;

	@ExcelAttribute(name = "档案-县", isArea = true, parentField = "fileCity")
	@Schema(description = "档案-县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("档案-县")
	private String fileTown;

	@ExcelAttribute(name = "岗位", maxLength = 30)
	@Schema(description = "岗位")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("岗位")
	private String post;

	@ExcelAttribute(name = "试用期", maxLength = 32)
	@Schema(description = "试用期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("试用期")
	private String tryPeriod;

	@ExcelAttribute(name = "工时制", maxLength = 1, readConverterExp = "1=标准工时,2=综合工时,3=不定时工时制")
	@Schema(description = "工时制：1标准工时 2 综合工时 3不定时工时制")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工时制")
	private String workingHours;

	@ExcelAttribute(name = "民族", isDataId = true, dataType = ExcelAttributeConstants.EMP_NATIONAL)
	@Schema(description = "民族")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("民族")
	private String empNational;

	@ExcelAttribute(name = "户口性质", isDataId = true, dataType = ExcelAttributeConstants.EMP_REGISTYPE)
	@Schema(description = "户口性质")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("户口性质")
	private String empRegisType;

	@ExcelAttribute(name = "合同类型", maxLength = 32, needExport = true)
	@Schema(description = "合同类型", name = "contractName")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同类型")
	private String contractName;

	@ExcelAttribute(name = "业务细分", maxLength = 32)
	@Schema(description = "业务细分", name = "contractSubName")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("业务细分")
	private String contractSubName;

	// 社保户——2022-7-26 15:02:00 倩倩告诉房工，社保户就是合同甲方
	@ExcelAttribute(name = "合同甲方", maxLength = 50, needExport = true)
	@Schema(description = "合同甲方")
	@Size(max = 50, message = "合同甲方不可超过50位")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同甲方")
	private String contractParty;

	@ExcelAttribute(name = "签订期限", maxLength = 32, isDataId = true, dataType = ExcelAttributeConstants.EMPLOYEE_CONTRACT_TYPE, needExport = true)
	@Schema(description = "签订期限", name = "contractType")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("签订期限")
	private String contractType;

	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "合同起始时间", isDate = true)
	@Schema(description = "合同起始时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同起始时间")
	private Date contractStart;

	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "合同到期时间", isDate = true)
	@Schema(description = "合同到期时间")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同到期时间")
	private Date contractEnd;

	@ExcelAttribute(name = "合同期限")
	@Schema(description = "合同期限")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("合同期限")
	private String contractTerm;

	@ExcelAttribute(name = "学历", maxLength = 32)
	@Schema(description = "学历", name = "contractName")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("学历")
	private String educationName;

	@ExcelAttribute(name = "备案基数", maxLength = 255)
	@Schema(description = "备案基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("备案基数")
	private String recordBase;

	// 2022-7-26 15:12:25 经房工指导
	@ExcelAttribute(name = "社保状态", readConverterExp = "0=派增待审核,1=派增待办理,2=派增办理中,3=派增办理成功,4=派增部分办理失败,5=派增办理失败,10=派增审核不通过,6=派减待审核,7=派减待办理,8=派减办理成功,9=派减办理失败")
	@Schema(description = "社保状态：0=派增待审核,1=派增待办理,2=派增办理中,3=派增办理成功,4=派增部分办理失败,5=派增办理失败,10=派增审核不通过,6=派减待审核,7=派减待办理,8=派减办理成功,9=派减办理失败")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保状态")
	private String socialStatus;

	@ExcelAttribute(name = "公积金状态", readConverterExp = "0=派增待审核,1=派增待办理,3=派增办理成功,4=派增办理失败,9=派增审核不通过,5=派减待审核,6=派减待办理,7=派减办理成功,8=派减办理失败")
	@Schema(description = "公积金状态：0=派增待审核,1=派增待办理,3=派增办理成功,4=派增办理失败,9=派增审核不通过,5=派减待审核,6=派减待办理,7=派减办理成功,8=派减办理失败")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金状态")
	private String fundStatus;

	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "社保起缴日期", isDate = true)
	@Schema(description = "社保起缴日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保起缴日期")
	private Date socialStartDate;

	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "公积金起缴日期", isDate = true)
	@Schema(description = "公积金起缴日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金起缴日期")
	private Date providentStart;

	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "社保停缴日期", isDate = true)
	@Schema(description = "社保停缴日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保停缴日期")
	private Date socialReduceDate;

	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "公积金停缴日期", isDate = true)
	@Schema(description = "公积金停缴日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金停缴日期")
	private Date fundReduceDate;

	@ExcelAttribute(name = "单位社保合计")
	@Schema(description = "单位社保合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位社保合计")
	private BigDecimal unitSocialSum;

	@ExcelAttribute(name = "个人社保合计")
	@Schema(description = "个人社保合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人社保合计")
	private BigDecimal personalSocialSum;

	@ExcelAttribute(name = "单位公积金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金")
	private BigDecimal unitFundSum;

	@ExcelAttribute(name = "个人公积金")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金")
	private BigDecimal personalFundSum;

	@ExcelAttribute(name = "总缴纳合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("总缴纳合计")
	private BigDecimal allSum;

	@ExcelAttribute(name = "社保户", maxLength = 50)
	@Schema(description = "社保户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保户")
	private String socialHouseholdName;

	@ExcelAttribute(name = "社保缴纳地-省", isArea = true)
	@Schema(description = "社保缴纳地-省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地-省")
	private String socialProvince;
	@ExcelAttribute(name = "社保缴纳地-市", isArea = true, parentField = "socialProvince")
	@Schema(description = "社保缴纳地-市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地-市")
	private String socialCity;
	@ExcelAttribute(name = "社保缴纳地-县", isArea = true, parentField = "socialCity")
	@Schema(description = "社保缴纳地-县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("社保缴纳地-县")
	private String socialTown;

	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "养老起缴日期", isDate = true)
	@Schema(description = "养老起缴日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养老起缴日期")
	private Date pensionStart;

	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "医疗起缴日期", isDate = true)
	@Schema(description = "医疗起缴日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医疗起缴日期")
	private Date medicalStart;

	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "失业起缴日期", isDate = true)
	@Schema(description = "失业起缴日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("失业起缴日期")
	private Date unemployStart;

	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "工伤起缴日期", isDate = true)
	@Schema(description = "工伤起缴日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工伤起缴日期")
	private Date workInjuryStart;

	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "生育起缴日期", isDate = true)
	@Schema(description = "生育起缴日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生育起缴日期")
	private Date birthStart;

	@DateTimeFormat("yyyy-MM-dd")
	@ExcelAttribute(name = "大病起缴日期", isDate = true)
	@Schema(description = "大病起缴日期")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病起缴日期")
	private Date bigailmentStart;

	@ExcelAttribute(name = "缴纳类型", readConverterExp = "0=最低,1=自定义,2=最高")
	@Schema(description = "缴纳类型（0最低、1自定义、2最高）")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("缴纳类型")
	private String paymentType;

	@ExcelAttribute(name = "养老基数")
	@Schema(description = "养老基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养老基数")
	private BigDecimal unitPensionCardinal;
	@ExcelAttribute(name = "单位养老比例")
	@Schema(description = "单位养老比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老比例")
	private BigDecimal unitPensionPer;
	@ExcelAttribute(name = "个人养老比例")
	@Schema(description = "个人养老比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老比例")
	private BigDecimal personalPensionPer;
	@ExcelAttribute(name = "单位养老金额")
	@Schema(description = "单位养老金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位养老金额")
	private BigDecimal unitPersionMoney;
	@ExcelAttribute(name = "个人养老金额")
	@Schema(description = "个人养老金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人养老金额")
	private BigDecimal personalPersionMoney;
	@ExcelAttribute(name = "养老金额合计")
	@Schema(description = "养老金额合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养老金额合计")
	private BigDecimal persionMoney;

	@ExcelAttribute(name = "医疗基数")
	@Schema(description = "医疗基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医疗基数")
	private BigDecimal unitMedicalCardinal;
	@ExcelAttribute(name = "单位医疗比例")
	@Schema(description = "单位医疗比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗比例")
	private BigDecimal unitMedicalPer;
	@ExcelAttribute(name = "个人医疗比例")
	@Schema(description = "个人医疗比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗比例")
	private BigDecimal personalMedicalPer;
	@ExcelAttribute(name = "单位医疗金额")
	@Schema(description = "单位医疗金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位医疗金额")
	private BigDecimal unitMedicalMoney;
	@ExcelAttribute(name = "个人医疗金额")
	@Schema(description = "个人医疗金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人医疗金额")
	private BigDecimal personalMedicalMoney;
	@ExcelAttribute(name = "医疗金额合计")
	@Schema(description = "医疗金额合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医疗金额合计")
	private BigDecimal medicalMoney;

	@ExcelAttribute(name = "失业基数")
	@Schema(description = "失业基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("失业基数")
	private BigDecimal unitUnemploymentCardinal;
	@ExcelAttribute(name = "单位失业比例")
	@Schema(description = "单位失业比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业比例")
	private BigDecimal unitUnemploymentPer;
	@ExcelAttribute(name = "个人失业比例")
	@Schema(description = "个人失业比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业比例")
	private BigDecimal personalUnemploymentPer;
	@ExcelAttribute(name = "单位失业金额")
	@Schema(description = "单位失业金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位失业金额")
	private BigDecimal unitUnemploymentMoney;
	@ExcelAttribute(name = "个人失业金额")
	@Schema(description = "个人失业金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人失业金额")
	private BigDecimal personalUnemploymentMoney;
	@ExcelAttribute(name = "失业金额合计")
	@Schema(description = "失业金额合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("失业金额合计")
	private BigDecimal unemploymentMoney;

	@ExcelAttribute(name = "工伤基数")
	@Schema(description = "工伤基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工伤基数")
	private BigDecimal unitWorkInjuryCardinal;
	@ExcelAttribute(name = "单位工伤比例")
	@Schema(description = "单位工伤比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤比例")
	private BigDecimal unitWorkUnjuryPer;
	@ExcelAttribute(name = "单位工伤金额")
	@Schema(description = "单位工伤金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位工伤金额")
	private BigDecimal unitInjuryMoney;

	@ExcelAttribute(name = "生育基数")
	@Schema(description = "生育基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生育基数")
	private BigDecimal unitBirthCardinal;
	@ExcelAttribute(name = "单位生育比例")
	@Schema(description = "单位生育比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育比例")
	private BigDecimal unitBirthPer;
	@ExcelAttribute(name = "单位生育金额")
	@Schema(description = "单位生育金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位生育金额")
	private BigDecimal unitBirthMoney;

	@ExcelAttribute(name = "大病基数")
	@Schema(description = "大病基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病基数")
	private BigDecimal unitBigailmentCardinal;
	@ExcelAttribute(name = "单位大病比例")
	@Schema(description = "单位大病比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病比例")
	private BigDecimal unitBigailmentPer;
	@ExcelAttribute(name = "个人大病比例")
	@Schema(description = "个人大病比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病比例")
	private BigDecimal personalBigailmentPer;
	@ExcelAttribute(name = "单位大病金额")
	@Schema(description = "单位大病金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位大病金额")
	private BigDecimal unitBigailmentMoney;
	@ExcelAttribute(name = "个人大病金额")
	@Schema(description = "个人大病金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人大病金额")
	private BigDecimal personalBigailmentMoney;
	@ExcelAttribute(name = "大病金额合计")
	@Schema(description = "大病金额合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病金额合计")
	private BigDecimal bigailmentMoney;

	@ExcelAttribute(name = "公积金户", maxLength = 50)
	@Schema(description = "公积金户")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金户")
	private String providentHouseholdName;

	@ExcelAttribute(name = "公积金缴纳地-省", isArea = true, maxLength = 32)
	@Schema(description = "公积金缴纳地-省")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地-省")
	private String fundProvince;
	@ExcelAttribute(name = "公积金缴纳地-市", isArea = true, parentField = "fundProvince")
	@Schema(description = "公积金缴纳地-市")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地-市")
	private String fundCity;
	@ExcelAttribute(name = "公积金缴纳地-县", isArea = true, parentField = "fundCity")
	@Schema(description = "公积金缴纳地-县")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金缴纳地-县")
	private String fundTown;

	@ExcelAttribute(name = "公积金基数")
	@Schema(description = "公积金基数")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金基数")
	private BigDecimal unitProvidengCardinal;

	@ExcelAttribute(name = "单位公积金比例")
	@Schema(description = "单位公积金比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金比例")
	private BigDecimal unitProvidentPer;
	@ExcelAttribute(name = "个人公积金比例")
	@Schema(description = "个人公积金比例")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金比例")
	private BigDecimal personalProvidentPer;
	@ExcelAttribute(name = "单位公积金金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("单位公积金金额")
	private BigDecimal unitFundSum2;
	@ExcelAttribute(name = "个人公积金金额")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("个人公积金金额")
	private BigDecimal personalFundSum2;
	@ExcelAttribute(name = "公积金金额合计")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("公积金金额合计")
	private BigDecimal fundSum;

	@ExcelAttribute(name = "委托备注", maxLength = 100)
	@Schema(description = "委托备注")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("委托备注")
	private String trustRemark;

	/**
	 * 养老办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@ExcelAttribute(name = "养老办理状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "养老办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("养老办理状态" )
	private String pensionHandle;
	/**
	 * 医疗办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@ExcelAttribute(name = "医疗办理状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "医疗办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("医疗办理状态" )
	private String medicalHandle;
	/**
	 * 失业办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@ExcelAttribute(name = "失业办理状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "失业办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("失业办理状态" )
	private String unemployHandle;
	/**
	 * 工伤办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@ExcelAttribute(name = "工伤办理状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "工伤办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("工伤办理状态" )
	private String workInjuryHandle;
	/**
	 * 生育办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@ExcelAttribute(name = "生育办理状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "生育办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("生育办理状态" )
	private String birthHandle;
	/**
	 * 大病办理状态：0待办理1办理成功2办理失败3已派减
	 */
	@ExcelAttribute(name = "大病办理状态", readConverterExp = "0=待办理,1=办理成功,2=办理失败,3=已派减")
	@Schema(description = "大病办理状态：0待办理1办理成功2办理失败3已派减" )
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty("大病办理状态" )
	private String bigailmentHandle;

}
